# Testing Guide - Phase 2: User Management

## Quick Testing Reference

### Prerequisites
- XAMPP running (Apache + MySQL)
- Database created and schema imported
- SMTP configured in config.php (for email testing)

---

## 1. Email Verification Testing

### Test URL:
```
http://localhost/obgyn-research-platform/verify-email.php?token=YOUR_TOKEN
```

### Test Cases:

**✅ Valid Token:**
1. Register a new user
2. Check database for verification_token
3. Visit: `verify-email.php?token=[token_from_db]`
4. Expected: Success message + redirect to login

**❌ Invalid Token:**
1. Visit: `verify-email.php?token=invalid_token_123`
2. Expected: Error message + option to resend

**❌ Expired Token:**
1. Use token older than 24 hours
2. Expected: Error message

**❌ No Token:**
1. Visit: `verify-email.php`
2. Expected: Warning message

---

## 2. Forgot Password Testing

### Test URL:
```
http://localhost/obgyn-research-platform/forgot-password.php
```

### Test Cases:

**✅ Valid Email:**
1. Enter registered email
2. Submit form
3. Expected: Success message
4. Check email for reset link

**❌ Invalid Email Format:**
1. Enter: `notanemail`
2. Expected: Validation error

**❌ Empty Email:**
1. Submit empty form
2. Expected: Error message

**🔒 Security Test:**
1. Enter non-existent email
2. Expected: Generic success message (doesn't reveal if email exists)

---

## 3. Reset Password Testing

### Test URL:
```
http://localhost/obgyn-research-platform/reset-password.php?token=YOUR_TOKEN
```

### Test Cases:

**✅ Valid Token:**
1. Request password reset
2. Get token from email or database
3. Visit: `reset-password.php?token=[token]`
4. Expected: Password reset form displayed

**✅ Password Reset:**
1. Enter new password (min 8 chars)
2. Confirm password
3. Submit
4. Expected: Success + redirect to login

**❌ Password Mismatch:**
1. Enter different passwords
2. Expected: Error message

**❌ Weak Password:**
1. Enter password < 8 characters
2. Expected: Validation error

**❌ Invalid/Expired Token:**
1. Use invalid token
2. Expected: Error + option to request new link

**🎨 UI Features to Test:**
- Password strength indicator changes color
- Password visibility toggle works
- Real-time password match validation

---

## 4. Two-Factor Authentication Testing

### Test URL:
```
http://localhost/obgyn-research-platform/verify-2fa.php
```

### Setup:
1. Enable 2FA for a test user in database:
```sql
UPDATE users SET two_factor_enabled = 1, two_factor_secret = 'test_secret' WHERE id = 1;
```

### Test Cases:

**✅ Valid Code:**
1. Login with 2FA-enabled account
2. Redirected to verify-2fa.php
3. Enter valid 6-digit code
4. Expected: Login successful + redirect to dashboard

**❌ Invalid Code:**
1. Enter wrong code (e.g., 000000)
2. Expected: Error message

**❌ Non-numeric Input:**
1. Try entering letters
2. Expected: Auto-filtered to numbers only

**❌ Direct Access:**
1. Visit verify-2fa.php without logging in
2. Expected: Redirect to login

**✅ Cancel:**
1. Click "Cancel & Return to Login"
2. Expected: Redirect to login page

**🎨 UI Features to Test:**
- Only accepts 6 digits
- Auto-formats input
- Paste handling works
- Auto-focus on input

---

## Database Queries for Testing

### Check Verification Token:
```sql
SELECT id, email, verification_token, email_verified 
FROM users 
WHERE email = 'test@example.com';
```

### Check Reset Token:
```sql
SELECT id, email, reset_token, reset_token_expiry 
FROM users 
WHERE email = 'test@example.com';
```

### Enable 2FA for Testing:
```sql
UPDATE users 
SET two_factor_enabled = 1, 
    two_factor_secret = 'JBSWY3DPEHPK3PXP' 
WHERE email = 'test@example.com';
```

### Check User Status:
```sql
SELECT id, email, status, email_verified, two_factor_enabled, last_login 
FROM users 
WHERE email = 'test@example.com';
```

---

## Complete User Flow Testing

### Flow 1: New User Registration
```
1. Go to: register.php
2. Fill registration form
3. Submit
4. Check email for verification link
5. Click verification link
6. Verify success message
7. Go to login.php
8. Login with credentials
9. Verify redirect to dashboard
```

### Flow 2: Password Reset
```
1. Go to: login.php
2. Click "Forgot Password"
3. Enter email
4. Check email for reset link
5. Click reset link
6. Enter new password
7. Confirm password
8. Submit
9. Verify success message
10. Login with new password
```

### Flow 3: 2FA Login
```
1. Enable 2FA for test user
2. Go to: login.php
3. Enter credentials
4. Submit
5. Redirected to verify-2fa.php
6. Open authenticator app
7. Enter 6-digit code
8. Submit
9. Verify redirect to dashboard
```

---

## Security Testing

### CSRF Protection:
1. Try submitting forms without CSRF token
2. Expected: Error/rejection

### SQL Injection:
1. Try: `' OR '1'='1` in email fields
2. Expected: Sanitized/rejected

### XSS Testing:
1. Try: `<script>alert('XSS')</script>` in inputs
2. Expected: Escaped/sanitized

### Session Testing:
1. Try accessing verify-2fa.php without session
2. Expected: Redirect to login

---

## Browser Testing

Test in multiple browsers:
- ✅ Chrome
- ✅ Firefox
- ✅ Safari
- ✅ Edge
- ✅ Mobile browsers

---

## Responsive Design Testing

Test on different screen sizes:
- ✅ Desktop (1920x1080)
- ✅ Laptop (1366x768)
- ✅ Tablet (768x1024)
- ✅ Mobile (375x667)

---

## Email Testing

### If SMTP is not configured:
1. Check `error_log` for email content
2. Or check database for tokens directly
3. Manually construct URLs with tokens

### If SMTP is configured:
1. Use real email service
2. Check spam folder
3. Verify email formatting
4. Test email links

---

## Common Issues & Solutions

### Issue: Email not received
**Solution:** 
- Check SMTP settings in config.php
- Check spam folder
- Use database tokens directly for testing

### Issue: Token expired
**Solution:**
- Tokens expire after 24 hours (verification) or 1 hour (reset)
- Generate new token or extend expiry in database

### Issue: 2FA not working
**Solution:**
- Ensure two_factor_enabled = 1 in database
- Use valid authenticator app
- Check two_factor_secret is set

### Issue: Redirect not working
**Solution:**
- Check if researcher/dashboard.php exists
- Verify SITE_URL in config.php
- Check for PHP errors

---

## Performance Testing

### Page Load Times:
- All pages should load < 1 second
- Forms should submit < 2 seconds
- Database queries should be < 100ms

### Concurrent Users:
- Test with multiple users simultaneously
- Check for session conflicts
- Verify database connection handling

---

## Accessibility Testing

- ✅ Keyboard navigation works
- ✅ Screen reader compatible
- ✅ Proper ARIA labels
- ✅ Color contrast sufficient
- ✅ Form labels associated correctly

---

## Final Checklist

Before marking Phase 2 complete:

- [ ] All 4 pages created and accessible
- [ ] Email verification works
- [ ] Password reset works
- [ ] 2FA verification works
- [ ] All forms have CSRF protection
- [ ] Input validation works (client & server)
- [ ] Error messages display correctly
- [ ] Success messages display correctly
- [ ] Redirects work properly
- [ ] Mobile responsive
- [ ] Cross-browser compatible
- [ ] Security measures in place
- [ ] No console errors
- [ ] No PHP errors
- [ ] Database queries optimized
- [ ] Code follows project standards

---

**Last Updated:** January 10, 2025  
**Status:** Ready for Testing
