<?php
require_once '../config/config.php';
$pageTitle = 'Contact Us';
$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    validateCSRF();
    
    $name = sanitize($_POST['name'] ?? '');
    $email = sanitize($_POST['email'] ?? '');
    $subject = sanitize($_POST['subject'] ?? '');
    $message = sanitize($_POST['message'] ?? '');
    
    if (empty($name) || empty($email) || empty($subject) || empty($message)) {
        $error = 'Please fill in all fields.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } else {
        // Send email to admin
        $emailBody = "Name: $name\nEmail: $email\nSubject: $subject\n\nMessage:\n$message";
        sendEmail(SITE_EMAIL, "Contact Form: $subject", $emailBody);
        $success = 'Thank you for contacting us. We will get back to you soon!';
    }
}

include '../templates/header.php';
?>

<div class="container my-5">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <h1 class="mb-4">Contact Us</h1>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo e($success); ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?php echo e($error); ?></div>
            <?php endif; ?>
            
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <form method="POST">
                        <?php echo csrfField(); ?>
                        
                        <div class="mb-3">
                            <label class="form-label">Name *</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Email *</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Subject *</label>
                            <input type="text" class="form-control" name="subject" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Message *</label>
                            <textarea class="form-control" name="message" rows="6" required></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane"></i> Send Message
                        </button>
                    </form>
                </div>
            </div>
            
            <?php 
            $contactInfo = getContactInfo();
            $socialMedia = getSocialMediaLinks();
            ?>
            
            <div class="row g-4 mb-4">
                <?php if (!empty($contactInfo['email_primary'])): ?>
                <div class="col-md-4">
                    <div class="card text-center h-100">
                        <div class="card-body">
                            <i class="fas fa-envelope fa-2x text-primary mb-3"></i>
                            <h5>Email Us</h5>
                            <p class="small mb-1">
                                <a href="mailto:<?php echo e($contactInfo['email_primary']); ?>">
                                    <?php echo e($contactInfo['email_primary']); ?>
                                </a>
                            </p>
                            <?php if (!empty($contactInfo['email_support'])): ?>
                            <p class="small text-muted mb-0">
                                Support: <a href="mailto:<?php echo e($contactInfo['email_support']); ?>">
                                    <?php echo e($contactInfo['email_support']); ?>
                                </a>
                            </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($contactInfo['phone_primary'])): ?>
                <div class="col-md-4">
                    <div class="card text-center h-100">
                        <div class="card-body">
                            <i class="fas fa-phone fa-2x text-success mb-3"></i>
                            <h5>Call Us</h5>
                            <p class="small mb-1">
                                <a href="tel:<?php echo e($contactInfo['phone_primary']); ?>">
                                    <?php echo e($contactInfo['phone_primary']); ?>
                                </a>
                            </p>
                            <?php if (!empty($contactInfo['phone_secondary'])): ?>
                            <p class="small text-muted mb-0">
                                <a href="tel:<?php echo e($contactInfo['phone_secondary']); ?>">
                                    <?php echo e($contactInfo['phone_secondary']); ?>
                                </a>
                            </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($contactInfo['address_line1']) || !empty($contactInfo['city'])): ?>
                <div class="col-md-4">
                    <div class="card text-center h-100">
                        <div class="card-body">
                            <i class="fas fa-map-marker-alt fa-2x text-danger mb-3"></i>
                            <h5>Visit Us</h5>
                            <p class="small mb-0">
                                <?php if (!empty($contactInfo['address_line1'])): ?>
                                    <?php echo e($contactInfo['address_line1']); ?><br>
                                <?php endif; ?>
                                <?php if (!empty($contactInfo['address_line2'])): ?>
                                    <?php echo e($contactInfo['address_line2']); ?><br>
                                <?php endif; ?>
                                <?php if (!empty($contactInfo['city'])): ?>
                                    <?php echo e($contactInfo['city']); ?>
                                    <?php if (!empty($contactInfo['state'])): ?>, <?php echo e($contactInfo['state']); ?><?php endif; ?>
                                    <?php if (!empty($contactInfo['postal_code'])): ?> <?php echo e($contactInfo['postal_code']); ?><?php endif; ?>
                                    <br>
                                <?php endif; ?>
                                <?php if (!empty($contactInfo['country'])): ?>
                                    <?php echo e($contactInfo['country']); ?>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <?php if (!empty($contactInfo['working_hours'])): ?>
            <div class="card mb-4">
                <div class="card-body">
                    <h5><i class="fas fa-clock text-info"></i> Working Hours</h5>
                    <p class="mb-0" style="white-space: pre-line;"><?php echo e($contactInfo['working_hours']); ?></p>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($socialMedia)): ?>
            <div class="card mb-4">
                <div class="card-body text-center">
                    <h5 class="mb-3">Connect With Us</h5>
                    <div class="d-flex justify-content-center gap-3 flex-wrap">
                        <?php echo displaySocialMediaIcons('fs-3'); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="card text-center h-100">
                        <div class="card-body">
                            <i class="fas fa-question-circle fa-2x text-success mb-3"></i>
                            <h5>Help Center</h5>
                            <p class="small">Find answers to common questions</p>
                            <a href="help.php" class="btn btn-sm btn-outline-success">Visit Help Center</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card text-center h-100">
                        <div class="card-body">
                            <i class="fas fa-comments fa-2x text-info mb-3"></i>
                            <h5>FAQ</h5>
                            <p class="small">Browse frequently asked questions</p>
                            <a href="faq.php" class="btn btn-sm btn-outline-info">View FAQ</a>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if (!empty($contactInfo['map_latitude']) && !empty($contactInfo['map_longitude'])): ?>
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="mb-3"><i class="fas fa-map text-primary"></i> Find Us on Map</h5>
                    <div class="ratio ratio-16x9">
                        <iframe 
                            src="https://maps.google.com/maps?q=<?php echo e($contactInfo['map_latitude']); ?>,<?php echo e($contactInfo['map_longitude']); ?>&hl=en&z=14&output=embed"
                            style="border:0;" 
                            allowfullscreen="" 
                            loading="lazy">
                        </iframe>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../templates/footer.php'; ?>
