<?php
require_once '../config/config.php';

$pubId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$pubId) redirect(SITE_URL . '/public/publications.php');

$db = getDB();
$stmt = $db->prepare("
    SELECT p.*, u.first_name, u.last_name, u.id as user_id
    FROM publications p
    JOIN users u ON p.user_id = u.id
    WHERE p.id = ? AND p.status = 'published' AND p.approval_status = 'approved'
");
$stmt->execute([$pubId]);
$pub = $stmt->fetch();

if (!$pub) redirect(SITE_URL . '/public/publications.php');

$pageTitle = $pub['title'];

include '../templates/header.php';
?>

<div class="container my-5">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo SITE_URL; ?>">Home</a></li>
            <li class="breadcrumb-item"><a href="publications.php">Publications</a></li>
            <li class="breadcrumb-item active"><?php echo e(substr($pub['title'], 0, 50)); ?></li>
        </ol>
    </nav>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h1 class="h2 mb-3"><?php echo e($pub['title']); ?></h1>
                    
                    <div class="mb-4">
                        <p class="text-muted mb-1">
                            <i class="fas fa-user"></i> <strong>Author:</strong> 
                            <a href="researcher-profile.php?id=<?php echo $pub['user_id']; ?>"><?php echo e($pub['first_name'] . ' ' . $pub['last_name']); ?></a>
                        </p>
                        <?php if ($pub['journal']): ?>
                            <p class="text-muted mb-1"><i class="fas fa-book"></i> <strong>Journal:</strong> <?php echo e($pub['journal']); ?></p>
                        <?php endif; ?>
                        <p class="text-muted mb-1"><i class="fas fa-calendar"></i> <strong>Published:</strong> <?php echo date('F d, Y', strtotime($pub['publication_date'])); ?></p>
                        <?php if ($pub['doi']): ?>
                            <p class="text-muted mb-1"><i class="fas fa-link"></i> <strong>DOI:</strong> <?php echo e($pub['doi']); ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($pub['abstract']): ?>
                    <hr>
                    <h4>Abstract</h4>
                    <p><?php echo nl2br(e($pub['abstract'])); ?></p>
                    <?php endif; ?>
                    
                    <?php if ($pub['url']): ?>
                    <hr>
                    <a href="<?php echo e($pub['url']); ?>" target="_blank" class="btn btn-primary">
                        <i class="fas fa-external-link-alt"></i> View Full Publication
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h6 class="mb-0">Publication Info</h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2"><strong>Type:</strong> <?php echo ucfirst($pub['type'] ?? 'Article'); ?></li>
                        <li class="mb-2"><strong>Status:</strong> <?php echo ucfirst($pub['status']); ?></li>
                        <li><strong>Added:</strong> <?php echo date('M d, Y', strtotime($pub['created_at'])); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../templates/footer.php'; ?>
