<?php
/**
 * Researcher Dashboard Sidebar
 * Shared sidebar component for all researcher pages
 */

// Get current page for active state
$currentPage = basename($_SERVER['PHP_SELF']);

// Get notification counts
$db = getDB();
$userId = getCurrentUserId();

$stmt = $db->prepare("SELECT COUNT(*) FROM notifications WHERE user_id = ? AND is_read = 0");
$stmt->execute([$userId]);
$unreadNotifications = $stmt->fetchColumn();

$stmt = $db->prepare("SELECT COUNT(*) FROM study_collaborators WHERE user_id = ? AND status = 'pending'");
$stmt->execute([$userId]);
$pendingInvitations = $stmt->fetchColumn();

$stmt = $db->prepare("SELECT COUNT(*) FROM studies WHERE creator_id = ?");
$stmt->execute([$userId]);
$studiesCount = $stmt->fetchColumn();
?>

<nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php">
                    <i class="fas fa-home"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo in_array($currentPage, ['profile.php', 'edit-profile.php']) ? 'active' : ''; ?>" href="profile.php">
                    <i class="fas fa-user"></i> My Profile
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo in_array($currentPage, ['studies.php', 'create-study.php', 'edit-study.php']) ? 'active' : ''; ?>" href="studies.php">
                    <i class="fas fa-flask"></i> My Studies
                    <?php if ($studiesCount > 0): ?>
                        <span class="badge bg-primary"><?php echo $studiesCount; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'collaborations.php' ? 'active' : ''; ?>" href="collaborations.php">
                    <i class="fas fa-users"></i> Collaborations
                    <?php if ($pendingInvitations > 0): ?>
                        <span class="badge bg-warning"><?php echo $pendingInvitations; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'messages.php' ? 'active' : ''; ?>" href="messages.php">
                    <i class="fas fa-envelope"></i> Messages
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'notifications.php' ? 'active' : ''; ?>" href="notifications.php">
                    <i class="fas fa-bell"></i> Notifications
                    <?php if ($unreadNotifications > 0): ?>
                        <span class="badge bg-danger"><?php echo $unreadNotifications; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'settings.php' ? 'active' : ''; ?>" href="settings.php">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </li>
        </ul>
    </div>
</nav>

<style>
.sidebar {
    position: fixed;
    top: 56px;
    bottom: 0;
    left: 0;
    z-index: 100;
    padding: 0;
    box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
    overflow-y: auto;
}

.sidebar .nav-link {
    font-weight: 500;
    color: #333;
    padding: 0.75rem 1rem;
}

.sidebar .nav-link:hover {
    background-color: #f8f9fa;
}

.sidebar .nav-link.active {
    color: #007bff;
    background-color: #e7f3ff;
    border-left: 3px solid #007bff;
}

.sidebar .nav-link i {
    margin-right: 0.5rem;
}

main {
    margin-top: 56px;
}
</style>
