<?php
echo "<h1>Path Test</h1>";
echo "<p><strong>SCRIPT_NAME:</strong> " . $_SERVER['SCRIPT_NAME'] . "</p>";
echo "<p><strong>dirname(SCRIPT_NAME):</strong> " . dirname($_SERVER['SCRIPT_NAME']) . "</p>";
echo "<p><strong>HTTP_HOST:</strong> " . $_SERVER['HTTP_HOST'] . "</p>";
echo "<p><strong>DOCUMENT_ROOT:</strong> " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p><strong>__FILE__:</strong> " . __FILE__ . "</p>";
echo "<p><strong>__DIR__:</strong> " . __DIR__ . "</p>";

$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$scriptDir = dirname($_SERVER['SCRIPT_NAME']);
$scriptDir = str_replace('\\', '/', $scriptDir);
$baseUrl = $protocol . '://' . $host . $scriptDir;
$finalUrl = rtrim($baseUrl, '/');

echo "<p><strong>Calculated SITE_URL:</strong> " . $finalUrl . "</p>";
echo "<p><strong>CSS URL would be:</strong> " . $finalUrl . "/assets/css/style.css</p>";

echo "<h2>Test Links:</h2>";
echo '<p><a href="' . $finalUrl . '/assets/css/style.css">Click to test CSS file</a></p>';
echo '<p><a href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">Click to test Bootstrap CDN</a></p>';

echo "<h2>File Checks:</h2>";
$cssFile = __DIR__ . '/assets/css/style.css';
echo "<p><strong>CSS file exists:</strong> " . (file_exists($cssFile) ? 'YES' : 'NO') . "</p>";
echo "<p><strong>CSS file path:</strong> " . $cssFile . "</p>";

$logoFile = __DIR__ . '/assets/images/logo.png';
echo "<p><strong>Logo file exists:</strong> " . (file_exists($logoFile) ? 'YES' : 'NO') . "</p>";
echo "<p><strong>Logo file path:</strong> " . $logoFile . "</p>";
?>
