<?php
/**
 * Add Missing Columns to cms_posts Table
 */

session_start();
require_once '../config/database.php';

// Simple admin check
if (!isset($_SESSION['user_id'])) {
    die('<h1>Access Denied</h1><p>Please <a href="../login.php">login</a> first.</p>');
}

try {
    $db = getDB();
    $stmt = $db->prepare("SELECT role_id FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
    
    if (!$user || ($user['role_id'] != 1 && $user['role_id'] != 2)) {
        die('<h1>Access Denied</h1><p>Admin access required.</p>');
    }
} catch (Exception $e) {
    die('<h1>Database Error</h1><p>' . $e->getMessage() . '</p>');
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>Add CMS Posts Columns</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css' rel='stylesheet'>
</head>
<body>
<div class='container mt-5'>
    <h1>Adding Missing Columns to cms_posts Table</h1>
    <div class='alert alert-info'>
        <p>This script will add the following columns if they don't exist:</p>
        <ul>
            <li><code>featured</code> - TINYINT(1) DEFAULT 0</li>
            <li><code>allow_comments</code> - TINYINT(1) DEFAULT 1</li>
            <li><code>views</code> - INT(11) DEFAULT 0 (alias for views_count)</li>
        </ul>
    </div>
    
    <?php
    try {
        $db = getDB();
        $success = [];
        $errors = [];
        
        // Check and add 'featured' column
        echo "<p>Checking for 'featured' column...</p>";
        $stmt = $db->query("SHOW COLUMNS FROM cms_posts LIKE 'featured'");
        if ($stmt->rowCount() == 0) {
            echo "<p class='text-info'>Adding 'featured' column...</p>";
            $db->exec("ALTER TABLE cms_posts ADD COLUMN featured TINYINT(1) DEFAULT 0 AFTER status");
            echo "<p class='text-success'>✓ Added 'featured' column</p>";
            $success[] = 'featured column added';
        } else {
            echo "<p class='text-warning'>⚠️ 'featured' column already exists</p>";
        }
        
        // Check and add 'allow_comments' column
        echo "<p>Checking for 'allow_comments' column...</p>";
        $stmt = $db->query("SHOW COLUMNS FROM cms_posts LIKE 'allow_comments'");
        if ($stmt->rowCount() == 0) {
            echo "<p class='text-info'>Adding 'allow_comments' column...</p>";
            $db->exec("ALTER TABLE cms_posts ADD COLUMN allow_comments TINYINT(1) DEFAULT 1 AFTER featured");
            echo "<p class='text-success'>✓ Added 'allow_comments' column</p>";
            $success[] = 'allow_comments column added';
        } else {
            echo "<p class='text-warning'>⚠️ 'allow_comments' column already exists</p>";
        }
        
        // Check if views_count exists and add views as alias
        echo "<p>Checking for 'views' column...</p>";
        $stmt = $db->query("SHOW COLUMNS FROM cms_posts LIKE 'views'");
        if ($stmt->rowCount() == 0) {
            // Check if views_count exists
            $stmt = $db->query("SHOW COLUMNS FROM cms_posts LIKE 'views_count'");
            if ($stmt->rowCount() > 0) {
                echo "<p class='text-info'>Note: 'views_count' column exists. We'll use that instead of adding 'views'.</p>";
                echo "<p class='text-success'>✓ No action needed - using existing 'views_count' column</p>";
            } else {
                echo "<p class='text-info'>Adding 'views' column...</p>";
                $db->exec("ALTER TABLE cms_posts ADD COLUMN views INT(11) DEFAULT 0 AFTER allow_comments");
                echo "<p class='text-success'>✓ Added 'views' column</p>";
                $success[] = 'views column added';
            }
        } else {
            echo "<p class='text-warning'>⚠️ 'views' column already exists</p>";
        }
        
        echo "<hr>";
        echo "<div class='alert alert-success'>";
        echo "<h3>✓ Column Check Complete!</h3>";
        if (count($success) > 0) {
            echo "<p><strong>Changes made:</strong></p>";
            echo "<ul>";
            foreach ($success as $item) {
                echo "<li>{$item}</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>All required columns already exist. No changes needed.</p>";
        }
        echo "</div>";
        
        echo "<div class='alert alert-info'>";
        echo "<h4>Next Step:</h4>";
        echo "<p>Now you can run the blog dummy data script:</p>";
        echo "<p><a href='create_blog_dummy_data_simple.php' class='btn btn-primary'>Create Blog Dummy Data</a></p>";
        echo "</div>";
        
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>";
        echo "<h3>Error!</h3>";
        echo "<p>" . $e->getMessage() . "</p>";
        echo "</div>";
    }
    ?>
</div>
</body>
</html>
