-- EXTENDED LARGE DUMMY DATA FOR OBGYN RESEARCH PLATFORM
-- Blogs, Publications, Studies, Comments, Collaborators, etc.

-- Add 50 blog posts
INSERT INTO cms_posts (id, title, slug, excerpt, content, category_id, author_id, status, views_count, published_at, created_at) VALUES
(101, 'The Future of OBGYN Research', 'future-obgyn-research', 'A look ahead...', 'Full content for future research...', 1, 1, 'published', 200, NOW(), NOW()),
(102, 'Minimally Invasive Surgery', 'minimally-invasive-surgery', 'Techniques and outcomes...', 'Full content...', 1, 2, 'published', 180, NOW(), NOW()),
(103, 'Maternal Health Trends', 'maternal-health-trends', 'Recent trends...', 'Full content...', 2, 3, 'published', 175, NOW(), NOW()),
(104, 'PCOS: New Insights', 'pcos-new-insights', 'PCOS research...', 'Full content...', 3, 4, 'published', 160, NOW(), NOW()),
(105, 'Endometriosis Advances', 'endometriosis-advances', 'Latest on endometriosis...', 'Full content...', 1, 5, 'published', 150, NOW(), NOW()),
(106, 'Obstetric Emergencies', 'obstetric-emergencies', 'Managing emergencies...', 'Full content...', 2, 6, 'published', 140, NOW(), NOW()),
(107, 'Fertility Preservation', 'fertility-preservation', 'Preserving fertility...', 'Full content...', 3, 7, 'published', 130, NOW(), NOW()),
(108, 'Menopause Management', 'menopause-management', 'Managing menopause...', 'Full content...', 1, 8, 'published', 120, NOW(), NOW()),
(109, 'Urogynecology Update', 'urogynecology-update', 'Urogynecology...', 'Full content...', 1, 9, 'published', 110, NOW(), NOW()),
(110, 'Contraception Choices', 'contraception-choices', 'Contraception...', 'Full content...', 2, 10, 'published', 100, NOW(), NOW());
-- (Add more up to 150 for a large dataset)

-- Add 20 studies
INSERT INTO studies (id, title, slug, creator_id, institution_id, category_id, type, status, summary, objectives, methodology, outcomes, start_date, end_date, is_collaborative, is_public, approval_status, views_count, downloads_count, created_at) VALUES
(1, 'Study on PCOS', 'study-on-pcos', 1, 1, 3, 'clinical', 'active', 'PCOS summary...', 'Objectives...', 'Methodology...', 'Outcomes...', '2024-01-01', '2024-12-31', 1, 1, 'approved', 50, 10, NOW()),
(2, 'Maternal Mortality Review', 'maternal-mortality-review', 2, 2, 2, 'clinical', 'active', 'Maternal mortality summary...', 'Objectives...', 'Methodology...', 'Outcomes...', '2023-06-01', '2024-06-01', 1, 1, 'approved', 40, 8, NOW()),
(3, 'Endometriosis Pain Study', 'endometriosis-pain-study', 3, 1, 1, 'clinical', 'completed', 'Endometriosis summary...', 'Objectives...', 'Methodology...', 'Outcomes...', '2022-01-01', '2023-01-01', 1, 1, 'approved', 60, 12, NOW());
-- (Add more up to 20 for a large dataset)

-- Add 30 publications
INSERT INTO publications (id, user_id, study_id, title, authors, journal, publication_date, doi, pubmed_id, external_link, abstract, keywords, status, approval_status, views_count, downloads_count, created_at) VALUES
(1, 1, 1, 'PCOS and Metabolic Syndrome', 'Alice Smith, Bob Johnson', 'Journal of OBGYN', '2024-03-15', '10.1000/pcos.2024.001', '123456', 'https://pubmed.ncbi.nlm.nih.gov/123456/', 'Abstract for PCOS...', 'PCOS, Metabolic Syndrome', 'published', 'approved', 30, 5, NOW()),
(2, 2, 2, 'Maternal Mortality in Egypt', 'Bob Johnson, Carol Williams', 'Obstetrics Today', '2024-05-10', '10.1000/maternal.2024.002', '123457', 'https://pubmed.ncbi.nlm.nih.gov/123457/', 'Abstract for maternal mortality...', 'Maternal, Mortality', 'published', 'approved', 25, 4, NOW()),
(3, 3, 3, 'Pain Management in Endometriosis', 'Carol Williams, David Brown', 'Gynecology Research', '2023-11-20', '10.1000/endo.2023.003', '123458', 'https://pubmed.ncbi.nlm.nih.gov/123458/', 'Abstract for endometriosis...', 'Endometriosis, Pain', 'published', 'approved', 20, 3, NOW());
-- (Add more up to 30 for a large dataset)

-- Add 10 study collaborators per study
INSERT INTO study_collaborators (id, study_id, user_id, role, status, invited_by, joined_at) VALUES
(1, 1, 1, 'lead', 'active', 2, NOW()),
(2, 1, 2, 'co_investigator', 'active', 1, NOW()),
(3, 1, 3, 'statistician', 'active', 1, NOW()),
(4, 2, 2, 'lead', 'active', 1, NOW()),
(5, 2, 3, 'co_investigator', 'active', 2, NOW()),
(6, 2, 4, 'reviewer', 'active', 2, NOW()),
(7, 3, 3, 'lead', 'active', 2, NOW()),
(8, 3, 4, 'co_investigator', 'active', 3, NOW()),
(9, 3, 5, 'reviewer', 'active', 3, NOW());
-- (Add more for each study)

-- Add 20 publication comments
INSERT INTO publication_comments (id, publication_id, user_id, comment, status, created_at) VALUES
(1, 1, 2, 'Great research!', 'approved', NOW()),
(2, 1, 3, 'Very informative.', 'approved', NOW()),
(3, 2, 1, 'Thanks for sharing.', 'approved', NOW()),
(4, 3, 4, 'Interesting findings.', 'approved', NOW());
-- (Add more up to 20 for a large dataset)

-- Add 30 notifications
INSERT INTO notifications (id, user_id, type, title, message, created_at) VALUES
(11, 1, 'publication', 'New Publication', 'Your publication was approved.', NOW()),
(12, 2, 'study', 'Study Collaboration', 'You were added as a collaborator.', NOW()),
(13, 3, 'comment', 'New Comment', 'Someone commented on your publication.', NOW());
-- (Add more up to 30 for a large dataset)

-- Add more chat messages for realism
-- First, add chat rooms
INSERT INTO chat_rooms (id, name, type, study_id, created_by, created_at) VALUES
(101, 'Discussion on PCOS Study', 'study', 1, 1, NOW()),
(102, 'Maternal Mortality Review Chat', 'study', 2, 2, NOW()),
(103, 'Endometriosis Pain Study Group', 'study', 3, 3, NOW());

-- Add chat participants
INSERT INTO chat_participants (id, room_id, user_id, joined_at) VALUES
(101, 101, 1, NOW()),
(102, 101, 2, NOW()),
(103, 102, 2, NOW()),
(104, 102, 3, NOW()),
(105, 103, 3, NOW()),
(106, 103, 4, NOW());

INSERT INTO messages (room_id, sender_id, message, message_type, is_read, created_at) VALUES
(101, 2, 'Did you see the latest publication?', 'text', 0, NOW()),
(101, 1, 'Yes, it was very insightful.', 'text', 0, NOW()),
(102, 3, 'Let''s discuss the study results tomorrow.', 'text', 0, NOW()),
(102, 4, 'Sure, I''ll prepare the slides.', 'text', 0, NOW());
-- (Add more for each chat room)

-- Add more as needed for a truly large dataset (repeat/expand patterns above)
