<?php
/**
 * Run Phase 7 Additional Features Migration
 * OBGYN Research Platform
 */

require_once dirname(__DIR__) . '/config/database.php';

try {
    $db = getDB();

    // Read the migration file
    $migrationSQL = file_get_contents(__DIR__ . '/phase7_additional_features_migration.sql');

    if (!$migrationSQL) {
        throw new Exception("Could not read migration file");
    }

    // Split into individual statements
    $statements = array_filter(array_map('trim', explode(';', $migrationSQL)));

    $db->beginTransaction();

    foreach ($statements as $statement) {
        // Remove comment lines
        $statement = preg_replace('/^--.*$/m', '', $statement);
        $statement = trim($statement);
        if (!empty($statement)) {
            echo "Executing: " . substr($statement, 0, 50) . "...\n";
            $db->exec($statement);
        }
    }

    $db->commit();

    echo "\n✅ Phase 7 migration completed successfully!\n";
    echo "New tables and columns have been added to the database.\n";

} catch (Exception $e) {
    if (isset($db) && $db->inTransaction()) {
        $db->rollBack();
    }
    echo "\n❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
?>
