<?php
// Determine the correct path to config
$configPath = '';
if (file_exists(__DIR__ . '/../config/config.php')) {
    $configPath = __DIR__ . '/../config/config.php';
} elseif (file_exists(dirname(dirname(__FILE__)) . '/config/config.php')) {
    $configPath = dirname(dirname(__FILE__)) . '/config/config.php';
}

if ($configPath && !defined('ROOT_PATH')) {
    require_once $configPath;
}

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$pageTitle = $pageTitle ?? SITE_NAME;
$flashMessage = getFlashMessage();

// Determine base URL dynamically if not set
if (!defined('SITE_URL') || empty(SITE_URL)) {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $basePath = '/obgyn-research-platform';
    $baseUrl = $protocol . '://' . $host . $basePath;
    define('SITE_URL_DYNAMIC', rtrim($baseUrl, '/'));
} else {
    define('SITE_URL_DYNAMIC', SITE_URL);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://unpkg.com; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://unpkg.com https://code.jquery.com; font-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data: https:;">
    <title><?php echo e($pageTitle); ?> - <?php echo e(getSiteName()); ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo SITE_URL_DYNAMIC; ?>/assets/css/style.css">
    
    <style>
        /* Offcanvas sidebar styles */
        .researcher-sidebar {
            width: 280px;
        }
        .researcher-sidebar .nav-link {
            color: #333;
            padding: 0.75rem 1rem;
            border-radius: 0.25rem;
            transition: all 0.3s;
        }
        .researcher-sidebar .nav-link:hover {
            background-color: #f8f9fa;
            color: #0d6efd;
        }
        .researcher-sidebar .nav-link.active {
            background-color: #0d6efd;
            color: white;
        }
        .researcher-sidebar .nav-link i {
            width: 20px;
            margin-right: 10px;
        }
    </style>
    
    <?php if (isset($additionalCSS)): ?>
        <?php echo $additionalCSS; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Top Bar with Menu Button -->
    <nav class="navbar navbar-dark bg-primary py-2">
        <div class="container-fluid">
            <div class="d-flex align-items-center gap-3">
                <!-- Menu Toggle Button -->
                <button class="btn btn-outline-light" type="button" data-bs-toggle="offcanvas" data-bs-target="#researcherSidebar" aria-controls="researcherSidebar">
                    <i class="fas fa-bars"></i>
                </button>
                
                <?php 
                $headerContactInfo = getContactInfo();
                $headerCompanyName = !empty($headerContactInfo['company_name']) ? $headerContactInfo['company_name'] : getSiteName();
                $logoUrl = getLogoUrl();
                ?>
                <a class="navbar-brand d-flex align-items-center gap-2 mb-0" href="<?php echo SITE_URL_DYNAMIC; ?>/index.php">
                    <?php if ($logoUrl && file_exists(str_replace(SITE_URL_DYNAMIC, ROOT_PATH, $logoUrl))): ?>
                        <img src="<?php echo $logoUrl; ?>" alt="<?php echo e($headerCompanyName); ?>" height="40">
                    <?php elseif (file_exists(ROOT_PATH . '/assets/images/logo.png')): ?>
                        <img src="<?php echo SITE_URL_DYNAMIC; ?>/assets/images/logo.png" alt="<?php echo e($headerCompanyName); ?>" height="40">
                    <?php else: ?>
                        <i class="fas fa-microscope fa-2x"></i>
                    <?php endif; ?>
                    <span class="fw-bold"><?php echo e($headerCompanyName); ?></span>
                </a>
            </div>
            
            <div class="d-flex align-items-center gap-3">
                <!-- Notifications -->
                <div class="dropdown">
                    <a class="text-white position-relative" href="#" id="notificationsDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-bell fa-lg"></i>
                        <?php 
                        $unreadCount = getUnreadNotificationsCount(getCurrentUserId());
                        if ($unreadCount > 0): 
                        ?>
                            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="font-size: 0.6rem;">
                                <?php echo $unreadCount > 9 ? '9+' : $unreadCount; ?>
                            </span>
                        <?php endif; ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><h6 class="dropdown-header">Notifications</h6></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-center small" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/notifications-enhanced.php">View All</a></li>
                    </ul>
                </div>
                
                <!-- User Menu -->
                <div class="dropdown">
                    <a class="text-white text-decoration-none dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user-circle fa-lg"></i>
                        <span class="ms-1 d-none d-md-inline"><?php echo e($_SESSION['user_name'] ?? 'User'); ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/profile.php">
                            <i class="fas fa-user"></i> My Profile
                        </a></li>
                        <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/settings.php">
                            <i class="fas fa-cog"></i> Settings
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/index.php">
                            <i class="fas fa-home"></i> Back to Main Site
                        </a></li>
                        <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/logout.php">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    
    <!-- Offcanvas Sidebar -->
    <div class="offcanvas offcanvas-start researcher-sidebar" tabindex="-1" id="researcherSidebar" aria-labelledby="researcherSidebarLabel">
        <div class="offcanvas-header bg-primary text-white">
            <h5 class="offcanvas-title" id="researcherSidebarLabel">
                <i class="fas fa-user-circle me-2"></i>
                Researcher Menu
            </h5>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body p-0">
            <nav class="nav flex-column p-3">
                <a class="nav-link <?php echo $currentPage === 'dashboard' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/dashboard.php">
                    <i class="fas fa-home"></i> Dashboard
                </a>
                <a class="nav-link <?php echo $currentPage === 'profile' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/profile.php">
                    <i class="fas fa-user"></i> My Profile
                </a>
                <a class="nav-link <?php echo $currentPage === 'studies' || $currentPage === 'create-study' || $currentPage === 'edit-study' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/studies.php">
                    <i class="fas fa-flask"></i> My Studies
                </a>
                <a class="nav-link <?php echo $currentPage === 'connections' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/connections.php">
                    <i class="fas fa-user-friends"></i> Connections
                </a>
                <a class="nav-link <?php echo $currentPage === 'collaborations' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/collaborations.php">
                    <i class="fas fa-handshake"></i> Collaborations
                </a>
                <a class="nav-link <?php echo $currentPage === 'messages' || $currentPage === 'messages-enhanced' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/messages-enhanced.php">
                    <i class="fas fa-envelope"></i> Messages
                </a>
                <a class="nav-link <?php echo $currentPage === 'notifications' || $currentPage === 'notifications-enhanced' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/notifications-enhanced.php">
                    <i class="fas fa-bell"></i> Notifications
                    <?php if ($unreadCount > 0): ?>
                        <span class="badge bg-danger ms-2"><?php echo $unreadCount; ?></span>
                    <?php endif; ?>
                </a>
                <a class="nav-link <?php echo $currentPage === 'settings' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/settings.php">
                    <i class="fas fa-cog"></i> Settings
                </a>
                
                <hr class="my-3">
                
                <a class="nav-link" href="<?php echo SITE_URL_DYNAMIC; ?>/index.php">
                    <i class="fas fa-arrow-left"></i> Back to Main Site
                </a>
                <a class="nav-link text-danger" href="<?php echo SITE_URL_DYNAMIC; ?>/logout.php">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </nav>
        </div>
    </div>
    
    <!-- Flash Messages -->
    <?php if ($flashMessage): ?>
        <div class="container-fluid mt-3">
            <div class="alert alert-<?php echo $flashMessage['type'] === 'error' ? 'danger' : $flashMessage['type']; ?> alert-dismissible fade show" role="alert">
                <?php echo e($flashMessage['message']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Main Content Wrapper -->
    <div class="container-fluid p-4">
