<?php
// Test script to debug researcher profile issue
require_once 'config/config.php';

echo "Testing researcher profile access...\n\n";

$testIds = [1, 27, 43]; // Test with different researchers

foreach ($testIds as $userId) {
    echo "Testing researcher ID: $userId\n";

    // Check if ID is valid
    if (!$userId) {
        echo "  - FAIL: Invalid user ID\n";
        continue;
    }

    $db = getDB();
    $stmt = $db->prepare("
        SELECT u.*, rp.*, i.name as institution_name
        FROM users u
        LEFT JOIN researcher_profiles rp ON u.id = rp.user_id
        LEFT JOIN institutions i ON rp.institution_id = i.id
        WHERE u.id = ? AND u.role_id = ? AND u.status = 'active'
    ");
    $stmt->execute([$userId, ROLE_RESEARCHER]);
    $researcher = $stmt->fetch();

    if (!$researcher) {
        echo "  - FAIL: Researcher not found in database\n";
        continue;
    }

    echo "  - SUCCESS: Found researcher: " . $researcher['first_name'] . ' ' . $researcher['last_name'] . "\n";

    // Test if we can include the header
    try {
        ob_start();
        include 'templates/header.php';
        $headerOutput = ob_get_clean();
        echo "  - SUCCESS: Header template loaded\n";
    } catch (Exception $e) {
        echo "  - FAIL: Header template error: " . $e->getMessage() . "\n";
    }
}

echo "\nSITE_URL: " . SITE_URL . "\n";
echo "Current working directory: " . getcwd() . "\n";
?>