<?php
/**
 * Script to update all admin pages to use admin-header.php
 * Run this once to update all admin pages
 */

$filesToUpdate = [
    'admin/users.php',
    'admin/studies.php',
    'admin/publications.php',
    'admin/institutions.php',
    'admin/categories.php',
    'admin/moderation.php',
    'admin/analytics.php',
    'admin/audit-logs.php',
    'admin/settings.php',
    'admin/cms-pages.php',
    'admin/cms-contact.php'
];

$updated = 0;
$errors = 0;

foreach ($filesToUpdate as $file) {
    if (!file_exists($file)) {
        echo "❌ File not found: $file\n";
        $errors++;
        continue;
    }
    
    $content = file_get_contents($file);
    
    // Replace old header include with new admin-header
    $oldPattern1 = "include '../templates/header.php';";
    $oldPattern2 = 'include "../templates/header.php";';
    $newInclude = "include '../templates/admin-header.php';";
    
    $originalContent = $content;
    $content = str_replace($oldPattern1, $newInclude, $content);
    $content = str_replace($oldPattern2, $newInclude, $content);
    
    if ($content !== $originalContent) {
        file_put_contents($file, $content);
        echo "✅ Updated: $file\n";
        $updated++;
    } else {
        echo "⚠️  No changes needed: $file\n";
    }
}

echo "\n";
echo "========================================\n";
echo "Summary:\n";
echo "✅ Updated: $updated files\n";
echo "❌ Errors: $errors files\n";
echo "========================================\n";
?>
