-- Notifications System Migration
-- OBGYN Research Platform

CREATE TABLE IF NOT EXISTS notifications (
    id INT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
    user_id INT UNSIGNED NOT NULL,
    type VARCHAR(50) NOT NULL, -- 'follow', 'contact_request', 'message', etc.
    title VARCHAR(255) NOT NULL,
    message TEXT NOT NULL,
    url VARCHAR(500), -- Link to relevant page
    is_read BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user (user_id),
    INDEX idx_type (type),
    INDEX idx_read (is_read),
    INDEX idx_created (created_at DESC)
);