# OBGYN Research & Collaboration Platform - Features

This document outlines the features of the OBGYN Research & Collaboration Platform, categorized by functionality. Each category includes a list of related files with brief descriptions of their purpose.

## 1. Authentication & User Management
Handles user registration, login, password management, and role-based access control.

- `login.php`: User login page with email/password authentication and 2FA support
- `register.php`: User registration form with email verification and validation
- `logout.php`: Handles user logout and session cleanup
- `reset-password.php`: Password reset functionality via email
- `verify-email.php`: Email verification for new user accounts
- `verify-2fa.php`: Two-factor authentication verification
- `includes/auth.php`: Authentication helper functions (login, register, session management)
- `includes/rbac.php`: Role-Based Access Control system with permissions

## 2. Admin Panel
Centralized administration interface for platform management.

- `admin/dashboard.php`: Main admin dashboard with platform statistics and overview
- `admin/users.php`: User management (view, edit, activate/deactivate users)
- `admin/studies.php`: Study moderation and management
- `admin/publications.php`: Publication approval and management
- `admin/institutions.php`: Institution management and hierarchy
- `admin/analytics.php`: Platform analytics and reporting
- `admin/audit-logs.php`: Security audit logs viewer
- `admin/settings.php`: Platform configuration settings
- `admin/moderation.php`: Content moderation tools
- `admin/categories.php`: Research category management
- `admin/cms-pages.php`: CMS page management
- `admin/cms-posts.php`: CMS blog post management
- `admin/cms-posts-edit.php`: Edit individual CMS posts
- `admin/cms-pages-edit.php`: Edit individual CMS pages
- `admin/cms-menus.php`: Menu management for CMS
- `admin/cms-menu-items.php`: Menu item management
- `admin/cms-contact.php`: Contact form management
- `admin/header-bar.php`: Admin header template
- `admin/sidebar.php`: Admin sidebar navigation
- `admin/sidebar-new.php`: Updated admin sidebar

## 3. Researcher Interface
Interface for researchers to manage their profiles, studies, and collaborations.

- `researcher/` (directory contains researcher-specific pages like dashboard, profile, studies management)

## 4. Public Pages
Public-facing pages for visitors and general users.

- `index.php`: Homepage with platform statistics and featured content
- `public/blog.php`: Public blog listing page
- `public/publications.php`: Publication listing and search
- `public/researchers.php`: Researcher directory
- `public/studies.php`: Public study listings
- `public/study-detail.php`: Individual study detail page
- `public/publication-detail.php`: Individual publication detail page
- `public/researcher-profile.php`: Public researcher profile pages
- `public/institutions.php`: Institution listings
- `public/about.php`: About page
- `public/contact.php`: Contact form
- `public/compliance.php`: Compliance information
- `public/faq.php`: Frequently asked questions
- `public/help.php`: Help and support
- `public/privacy.php`: Privacy policy
- `public/terms.php`: Terms of service

## 5. API Endpoints
RESTful API for frontend interactions and data operations.

- `api/studies.php`: CRUD operations for research studies
- `api/chat.php`: Chat messaging API
- `api/collaborators.php`: Study collaborator management
- `api/connections.php`: Researcher networking connections
- `api/notifications.php`: Notification system API
- `api/search.php`: Advanced search functionality
- `api/upload.php`: File upload handling

## 6. Content Management System (CMS)
Dynamic content creation and management.

- `admin/cms-pages.php`: Manage static pages
- `admin/cms-posts.php`: Manage blog posts
- `admin/cms-posts-edit.php`: Edit blog posts
- `admin/cms-pages-edit.php`: Edit static pages
- `admin/cms-menus.php`: Manage navigation menus
- `admin/cms-menu-items.php`: Manage menu items
- `public/blog.php`: Display published blog posts
- `public/post.php`: Individual blog post view

## 7. Database & Configuration
Database setup, configuration, and migration scripts.

- `config/config.php`: Main configuration file
- `config/database.php`: Database connection settings
- `database/schema.sql`: Database schema definition
- `database/create_admin_user.php`: Admin user creation script
- `database/create_blog_dummy_data.php`: Dummy blog data for testing
- `database/create_homepage_dummy_data.php`: Homepage dummy data
- `database/large_dummy_data.sql`: Large dataset for testing
- `database/chat_dummy_data.sql`: Chat dummy data
- `database/add_cms_posts_columns.php`: Database migration for CMS
- `database/test_cms_features.php`: CMS feature testing

## 8. Templates & Assets
UI templates and static assets.

- `templates/header.php`: Main header template
- `templates/footer.php`: Main footer template
- `templates/mobile-header.php`: Mobile header template
- `templates/mobile-footer.php`: Mobile footer template
- `templates/admin-header.php`: Admin header template
- `templates/admin-footer.php`: Admin footer template
- `templates/researcher-header.php`: Researcher header template
- `templates/researcher-mobile-header.php`: Researcher mobile header
- `templates/researcher-mobile-footer.php`: Researcher mobile footer
- `templates/header-mob.php`: Mobile header variant
- `templates/footer-mobile.php`: Mobile footer variant
- `templates/contact-section-snippet.php`: Contact section template
- `assets/css/`: Stylesheets
- `assets/js/`: JavaScript files
- `assets/images/`: Image assets
- `assets/uploads/`: User-uploaded files

## 9. Includes & Helpers
Common functions, security, and utility libraries.

- `includes/functions.php`: General utility functions (sanitization, validation, etc.)
- `includes/security.php`: Security-related functions
- `includes/auth.php`: Authentication functions
- `includes/rbac.php`: Role-based access control

## 10. Testing & Development
Testing scripts and development utilities.

- `test.php`: General testing script
- `test-db.php`: Database connection testing
- `test-db-alt.php`: Alternative database testing
- `update_admin_pages.php`: Admin page update script
- `update_admin_headers.php`: Admin header update script

## 11. Documentation
Project documentation and guides.

- `MD files/README.md`: Project overview and installation guide
- `MD files/PROJECT_SUMMARY.md`: Detailed project summary
- `MD files/INSTALLATION.md`: Installation instructions
- `MD files/SETUP_AND_TESTING_GUIDE.md`: Setup and testing guide
- `MD files/TESTING_GUIDE.md`: Testing procedures
- `MD files/TODO.md`: Development roadmap
- `MD files/PHASE*.md`: Phase-specific documentation
- `MD files/QUICK_FIX_GUIDE.md`: Quick fixes and troubleshooting</content>
<parameter name="filePath">c:\xampp\htdocs\obgyn-research-platform\features.md