<?php
/**
 * Forgot Password Page
 * OBGYN Research & Collaboration Platform
 */

require_once 'config/config.php';

// Redirect if already logged in
if (isLoggedIn()) {
    redirect(SITE_URL . '/researcher/dashboard.php');
}

$pageTitle = 'Forgot Password';
$error = '';
$success = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    validateCSRF();
    
    $email = sanitize($_POST['email'] ?? '');
    
    if (empty($email)) {
        $error = 'Please enter your email address.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Please enter a valid email address.';
    } else {
        $result = requestPasswordReset($email);
        
        if ($result['success']) {
            $success = $result['message'];
        } else {
            $error = $result['message'];
        }
    }
}

include 'templates/header.php';
?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="card shadow-lg mt-5">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <i class="fas fa-key fa-3x text-primary mb-3"></i>
                        <h2 class="fw-bold">Forgot Password?</h2>
                        <p class="text-muted">Enter your email to reset your password</p>
                    </div>
                    
                    <?php if ($error): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-circle"></i> <?php echo e($error); ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($success): ?>
                        <div class="alert alert-success" role="alert">
                            <i class="fas fa-check-circle"></i> <?php echo e($success); ?>
                        </div>
                        
                        <div class="text-center mt-4">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i>
                                <strong>Check your email!</strong><br>
                                If an account exists with that email, you will receive a password reset link shortly.
                            </div>
                            
                            <p class="text-muted small mb-3">
                                Didn't receive the email? Check your spam folder or try again.
                            </p>
                            
                            <a href="<?php echo SITE_URL; ?>/login.php" class="btn btn-primary w-100">
                                <i class="fas fa-arrow-left"></i> Back to Login
                            </a>
                        </div>
                    <?php else: ?>
                        <form method="POST" action="" class="needs-validation" novalidate>
                            <?php echo csrfField(); ?>
                            
                            <div class="mb-4">
                                <label for="email" class="form-label">Email Address</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?php echo e($_POST['email'] ?? ''); ?>" 
                                           placeholder="your.email@example.com" required>
                                    <div class="invalid-feedback">
                                        Please enter a valid email address.
                                    </div>
                                </div>
                                <small class="form-text text-muted">
                                    Enter the email address associated with your account.
                                </small>
                            </div>
                            
                            <button type="submit" class="btn btn-primary w-100 py-2 mb-3">
                                <i class="fas fa-paper-plane"></i> Send Reset Link
                            </button>
                            
                            <div class="text-center">
                                <a href="<?php echo SITE_URL; ?>/login.php" class="text-decoration-none">
                                    <i class="fas fa-arrow-left"></i> Back to Login
                                </a>
                            </div>
                        </form>
                        
                        <hr class="my-4">
                        
                        <div class="text-center">
                            <p class="mb-0 text-muted small">
                                <i class="fas fa-shield-alt"></i> Your security is important to us. 
                                The reset link will expire in 1 hour.
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="text-center mt-3">
                <a href="<?php echo SITE_URL; ?>/index.php" class="text-decoration-none">
                    <i class="fas fa-home"></i> Back to Home
                </a>
            </div>
        </div>
    </div>
</div>

<?php include 'templates/footer.php'; ?>
