<?php
require_once '../config/config.php';

$isMobile = preg_match('/Mobile|Android|iPhone|iPad|iPod/', $_SERVER['HTTP_USER_AGENT']);
$pageTitle = 'FAQ - Frequently Asked Questions';
// Include appropriate header based on device
if ($isMobile) {
    include '../templates/mobile-header.php';
} else {
    include '../templates/header.php';
}
?>

<?php 
    $faqContactInfo = getContactInfo();
    $faqCompanyName = !empty($faqContactInfo['company_name']) ? $faqContactInfo['company_name'] : getSiteName();
    $faqTagline = !empty($faqContactInfo['tagline']) ? $faqContactInfo['tagline'] : '';
?>
<div class="container my-5">
    <h1 class="mb-4">Frequently Asked Questions - <?php echo e($faqCompanyName); ?><?php if ($faqTagline) { echo ' <span class=\'small text-muted\'>' . e($faqTagline) . '</span>'; } ?></h1>
    
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="accordion" id="faqAccordion">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#q1">
                            What is <?php echo e($faqCompanyName); ?>?
                        </button>
                    </h2>
                    <div id="q1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            <?php echo e($faqCompanyName); ?><?php if ($faqTagline) { echo ' - <span class=\'small text-muted\'>' . e($faqTagline) . '</span>'; } ?> is a comprehensive digital ecosystem designed for obstetrics and gynecology researchers to collaborate, document research, and share knowledge globally.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q2">
                            Who can use this platform?
                        </button>
                    </h2>
                    <div id="q2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            The platform is designed for medical professionals, institutions, and anyone involved in obstetrics and gynecology research.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q3">
                            Is the platform free to use?
                        </button>
                    </h2>
                    <div id="q3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Yes, basic features are free for all registered users. Premium features may be available for institutions.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q4">
                            How do I collaborate with other researchers?
                        </button>
                    </h2>
                    <div id="q4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            You can search for researchers, send collaboration requests, add them to your studies, and communicate through our messaging system.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q5">
                            Is my research data secure?
                        </button>
                    </h2>
                    <div id="q5" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Yes, we use enterprise-grade security measures including encryption, 2FA, and comply with international data protection standards.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q6">
                            Can I make my studies private?
                        </button>
                    </h2>
                    <div id="q6" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Yes, you can control the visibility of your studies. You can make them public, private, or visible only to collaborators.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q7">
                            How do I publish my research?
                        </button>
                    </h2>
                    <div id="q7" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            You can add your published research to the platform by providing publication details, DOI, and links to the full text.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q8">
                            What file types can I upload?
                        </button>
                    </h2>
                    <div id="q8" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            You can upload PDF, DOC, DOCX, XLS, XLSX, and image files (JPG, PNG, GIF). Maximum file size is 10MB.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q9">
                            How do I delete my account?
                        </button>
                    </h2>
                    <div id="q9" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Go to Settings > Account > Delete Account. Note that this action is irreversible and will remove all your data.
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q10">
                            Who do I contact for support?
                        </button>
                    </h2>
                    <div id="q10" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            You can contact us through the <a href="contact.php">Contact Form</a> or email us at <?php echo SITE_EMAIL; ?>.
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card shadow-sm mt-4">
                <div class="card-body text-center">
                    <h5>Still have questions?</h5>
                    <p class="text-muted">We're here to help!</p>
                    <a href="contact.php" class="btn btn-primary">Contact Support</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php // Include appropriate footer based on device
if ($isMobile) {
    include '../templates/mobile-footer.php';
} else {
    include '../templates/footer.php';
} ?>
