</main>

<?php
// Get current page for active state
$currentPage = basename($_SERVER['PHP_SELF'], '.php');

// Check if user is logged in
$isLoggedIn = isLoggedIn();

// Define navigation items based on login status
if ($isLoggedIn) {
    // Logged in users see researcher navigation
    $navItems = [
        [
            'id' => 'dashboard',
            'icon' => 'fas fa-home',
            'label' => 'Dashboard',
            'url' => SITE_URL_DYNAMIC . '/researcher/dashboard.php'
        ],
        [
            'id' => 'profile',
            'icon' => 'fas fa-user',
            'label' => 'Profile',
            'url' => SITE_URL_DYNAMIC . '/researcher/profile.php'
        ],
        [
            'id' => 'messages-enhanced',
            'icon' => 'fas fa-envelope',
            'label' => 'Chats',
            'url' => SITE_URL_DYNAMIC . '/researcher/messages-enhanced.php'
        ],
        [
            'id' => 'studies',
            'icon' => 'fas fa-flask',
            'label' => 'Studies',
            'url' => SITE_URL_DYNAMIC . '/researcher/studies.php'
        ],
        [
            'id' => 'connections',
            'icon' => 'fas fa-user-friends',
            'label' => 'Connections',
            'url' => SITE_URL_DYNAMIC . '/researcher/connections.php'
        ],
        [
            'id' => 'collaborations',
            'icon' => 'fas fa-handshake',
            'label' => 'Collaborations',
            'url' => SITE_URL_DYNAMIC . '/researcher/collaborations.php'
        ],
        [
            'id' => 'notifications-enhanced',
            'icon' => 'fas fa-bell',
            'label' => 'Notifications',
            'url' => SITE_URL_DYNAMIC . '/researcher/notifications-enhanced.php'
        ],
        [
            'id' => 'settings',
            'icon' => 'fas fa-cog',
            'label' => 'Settings',
            'url' => SITE_URL_DYNAMIC . '/researcher/settings.php'
        ]
    ];
    
    // Handle alternative page names
    if ($currentPage === 'messages') {
        $currentPage = 'messages-enhanced';
    } elseif ($currentPage === 'notifications') {
        $currentPage = 'notifications-enhanced';
    }
} else {
    // Non-logged in users see public navigation
    $navItems = [
        [
            'id' => 'index',
            'icon' => 'fas fa-home',
            'label' => 'Home',
            'url' => SITE_URL_DYNAMIC . '/index.php'
        ],
        [
            'id' => 'about',
            'icon' => 'fas fa-info-circle',
            'label' => 'About',
            'url' => SITE_URL_DYNAMIC . '/public/about.php'
        ],
        [
            'id' => 'studies',
            'icon' => 'fas fa-flask',
            'label' => 'Studies',
            'url' => SITE_URL_DYNAMIC . '/public/studies.php'
        ],
        [
            'id' => 'researchers',
            'icon' => 'fas fa-users',
            'label' => 'Researchers',
            'url' => SITE_URL_DYNAMIC . '/public/researchers.php'
        ],
        [
            'id' => 'publications',
            'icon' => 'fas fa-book',
            'label' => 'Publications',
            'url' => SITE_URL_DYNAMIC . '/public/publications.php'
        ],
        [
            'id' => 'help',
            'icon' => 'fas fa-question-circle',
            'label' => 'Help',
            'url' => SITE_URL_DYNAMIC . '/public/help.php'
        ],
        [
            'id' => 'contact',
            'icon' => 'fas fa-envelope',
            'label' => 'Contact',
            'url' => SITE_URL_DYNAMIC . '/public/contact.php'
        ],
        [
            'id' => 'blog',
            'icon' => 'fas fa-blog',
            'label' => 'Blog',
            'url' => SITE_URL_DYNAMIC . '/public/blog.php'
        ]
    ];
}

// Find active item index
$activeIndex = 0;
foreach ($navItems as $index => $item) {
    if ($item['id'] === $currentPage) {
        $activeIndex = $index;
        break;
    }
}

// Calculate which page the active item is on (4 items per page)
$itemsPerPage = 4;
$activePage = floor($activeIndex / $itemsPerPage);
?>

<style>
/* Enhanced Mobile Footer with Pagination */
.mobile-footer-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    z-index: 1020;
    background: #fff;
    border-top: 1px solid #e9ecef;
    box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
    height: 80px;
    overflow: hidden;
}

.footer-nav-wrapper {
    position: relative;
    height: 100%;
    overflow: hidden;
}

.footer-nav-container {
    display: flex;
    height: 100%;
    transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    will-change: transform;
}

.footer-nav-page {
    display: flex;
    min-width: 100%;
    height: 100%;
    padding: 8px 0;
}

.footer-nav-item {
    flex: 1;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    color: #65676b;
    transition: all 0.2s ease;
    padding: 8px 4px;
    position: relative;
    gap: 4px;
}

.footer-nav-item:active {
    transform: scale(0.95);
}

.footer-nav-item.active {
    color: #0d6efd;
}

.footer-nav-item.active::before {
    content: '';
    position: absolute;
    top: 0;
    left: 50%;
    transform: translateX(-50%);
    width: 40px;
    height: 3px;
    background: #0d6efd;
    border-radius: 0 0 3px 3px;
}

.footer-nav-item i {
    font-size: 1.4rem;
    transition: transform 0.2s;
}

.footer-nav-item.active i {
    transform: scale(1.1);
}

.footer-nav-item span {
    font-size: 0.75rem;
    font-weight: 500;
    text-align: center;
    line-height: 1.2;
}

/* Page Indicators */
.footer-page-indicators {
    position: absolute;
    bottom: 4px;
    left: 50%;
    transform: translateX(-50%);
    display: flex;
    gap: 6px;
    z-index: 1;
}

.page-indicator {
    width: 6px;
    height: 6px;
    border-radius: 50%;
    background: #d0d0d0;
    transition: all 0.3s;
}

.page-indicator.active {
    background: #0d6efd;
    width: 20px;
    border-radius: 3px;
}

/* Scroll Hint Animation */
@keyframes scrollHint {
    0%, 100% {
        transform: translateX(0);
    }
    50% {
        transform: translateX(-8px);
    }
}

.footer-nav-container.hint-animation {
    animation: scrollHint 1s ease-in-out;
}

/* Swipe Indicator */
.swipe-hint {
    position: absolute;
    top: 50%;
    right: 16px;
    transform: translateY(-50%);
    color: #0d6efd;
    font-size: 1.5rem;
    opacity: 0;
    pointer-events: none;
    transition: opacity 0.3s;
}

.swipe-hint.show {
    opacity: 0.6;
    animation: swipeHintPulse 2s ease-in-out;
}

@keyframes swipeHintPulse {
    0%, 100% {
        opacity: 0;
    }
    50% {
        opacity: 0.6;
    }
}

/* Hide on desktop */
@media (min-width: 992px) {
    .mobile-footer-nav {
        display: none;
    }
}
</style>

<nav class="mobile-footer-nav">
    <div class="footer-nav-wrapper">
        <div class="footer-nav-container" id="footerNavContainer" data-active-page="<?php echo $activePage; ?>">
            <?php
            // Split items into pages of 4
            $pages = array_chunk($navItems, $itemsPerPage);
            foreach ($pages as $pageIndex => $pageItems):
            ?>
                <div class="footer-nav-page">
                    <?php foreach ($pageItems as $item): ?>
                        <a href="<?php echo $item['url']; ?>" 
                           class="footer-nav-item <?php echo $item['id'] === $currentPage ? 'active' : ''; ?>"
                           data-page="<?php echo $item['id']; ?>">
                            <i class="<?php echo $item['icon']; ?>"></i>
                            <span><?php echo $item['label']; ?></span>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Page Indicators -->
        <?php if (count($pages) > 1): ?>
            <div class="footer-page-indicators">
                <?php for ($i = 0; $i < count($pages); $i++): ?>
                    <div class="page-indicator <?php echo $i === $activePage ? 'active' : ''; ?>" data-page="<?php echo $i; ?>"></div>
                <?php endfor; ?>
            </div>
        <?php endif; ?>

        <!-- Swipe Hint -->
        <div class="swipe-hint" id="swipeHint">
            <i class="fas fa-chevron-left"></i>
        </div>
    </div>
</nav>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<!-- AOS (Animate On Scroll) JS -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<!-- LazyLoad JS -->
<script src="https://cdn.jsdelivr.net/npm/vanilla-lazyload@17.8.3/dist/lazyload.min.js"></script>

<!-- Custom JS -->
<script src="<?php echo SITE_URL_DYNAMIC; ?>/assets/js/main.js"></script>

<?php if (isset($additionalJS)): ?>
    <?php echo $additionalJS; ?>
<?php endif; ?>

<script>
// Enhanced Mobile Footer Navigation with Pagination
(function() {
    const container = document.getElementById('footerNavContainer');
    if (!container) return;
    
    const swipeHint = document.getElementById('swipeHint');
    const indicators = document.querySelectorAll('.page-indicator');
    const itemsPerPage = 4;
    const totalPages = Math.ceil(<?php echo count($navItems); ?> / itemsPerPage);
    let currentPage = parseInt(container.dataset.activePage) || 0;
    let startX = 0;
    let currentX = 0;
    let isDragging = false;
    let hasShownHint = localStorage.getItem('footerSwipeHintShown') === 'true';

    // Initialize - show active page
    function init() {
        goToPage(currentPage, false);
        
        // Show hint animation on first visit
        if (!hasShownHint && totalPages > 1) {
            setTimeout(showHintAnimation, 1000);
        }
    }

    // Show hint animation
    function showHintAnimation() {
        if (swipeHint) swipeHint.classList.add('show');
        container.classList.add('hint-animation');
        
        setTimeout(() => {
            if (swipeHint) swipeHint.classList.remove('show');
            container.classList.remove('hint-animation');
        }, 2000);
        
        localStorage.setItem('footerSwipeHintShown', 'true');
        hasShownHint = true;
    }

    // Go to specific page
    function goToPage(pageIndex, animate = true) {
        if (pageIndex < 0 || pageIndex >= totalPages) return;
        
        currentPage = pageIndex;
        const offset = -pageIndex * 100;
        
        if (!animate) {
            container.style.transition = 'none';
        }
        
        container.style.transform = `translateX(${offset}%)`;
        
        if (!animate) {
            setTimeout(() => {
                container.style.transition = '';
            }, 50);
        }
        
        // Update indicators
        indicators.forEach((indicator, index) => {
            indicator.classList.toggle('active', index === pageIndex);
        });
    }

    // Touch start
    container.addEventListener('touchstart', (e) => {
        startX = e.touches[0].clientX;
        currentX = startX;
        isDragging = true;
        container.style.transition = 'none';
    });

    // Touch move
    container.addEventListener('touchmove', (e) => {
        if (!isDragging) return;
        
        currentX = e.touches[0].clientX;
        const diff = currentX - startX;
        const currentOffset = -currentPage * 100;
        const dragOffset = (diff / window.innerWidth) * 100;
        
        // Add resistance at boundaries
        let finalOffset = currentOffset + dragOffset;
        if (currentPage === 0 && diff > 0) {
            finalOffset = currentOffset + (dragOffset * 0.3);
        } else if (currentPage === totalPages - 1 && diff < 0) {
            finalOffset = currentOffset + (dragOffset * 0.3);
        }
        
        container.style.transform = `translateX(${finalOffset}%)`;
    });

    // Touch end
    container.addEventListener('touchend', (e) => {
        if (!isDragging) return;
        
        isDragging = false;
        container.style.transition = '';
        
        const diff = currentX - startX;
        const threshold = window.innerWidth * 0.2;
        
        if (Math.abs(diff) > threshold) {
            if (diff > 0 && currentPage > 0) {
                goToPage(currentPage - 1);
            } else if (diff < 0 && currentPage < totalPages - 1) {
                goToPage(currentPage + 1);
            } else {
                goToPage(currentPage);
            }
        } else {
            goToPage(currentPage);
        }
    });

    // Click on indicators
    indicators.forEach((indicator, index) => {
        indicator.addEventListener('click', () => {
            goToPage(index);
        });
    });

    // Prevent default link behavior during drag
    const navItems = container.querySelectorAll('.footer-nav-item');
    navItems.forEach(item => {
        item.addEventListener('click', (e) => {
            if (Math.abs(currentX - startX) > 10) {
                e.preventDefault();
            }
        });
    });

    // Initialize on load
    init();

    // Periodic hint animation
    if (totalPages > 1) {
        const intervals = [10000, 20000, 40000, 80000, 160000];
        let intervalIndex = 0;

        function scheduleNextHint() {
            if (intervalIndex < intervals.length) {
                setTimeout(() => {
                    if (currentPage === parseInt(container.dataset.activePage)) {
                        showHintAnimation();
                    }
                    intervalIndex++;
                    scheduleNextHint();
                }, intervals[intervalIndex]);
            }
        }

        if (hasShownHint) {
            setTimeout(scheduleNextHint, intervals[0]);
        }
    }
})();
</script>

</body>
</html>
