<?php
/**
 * Email Verification Page
 * OBGYN Research & Collaboration Platform
 */

require_once 'config/config.php';

// Redirect if already logged in
if (isLoggedIn()) {
    redirect(SITE_URL . '/researcher/dashboard.php');
}

$pageTitle = 'Verify Email';
$error = '';
$success = '';
$token = $_GET['token'] ?? '';

// Handle verification
if (!empty($token)) {
    $result = verifyEmail($token);
    
    if ($result['success']) {
        $success = $result['message'];
    } else {
        $error = $result['message'];
    }
}

include 'templates/header.php';
?>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="card shadow-lg mt-5">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <?php if ($success): ?>
                            <i class="fas fa-check-circle fa-4x text-success mb-3"></i>
                            <h2 class="fw-bold text-success">Email Verified!</h2>
                        <?php else: ?>
                            <i class="fas fa-envelope-open-text fa-3x text-primary mb-3"></i>
                            <h2 class="fw-bold">Email Verification</h2>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($success): ?>
                        <div class="alert alert-success" role="alert">
                            <i class="fas fa-check-circle"></i> <?php echo e($success); ?>
                        </div>
                        
                        <div class="text-center mt-4">
                            <p class="mb-3">Your email has been successfully verified. You can now login to your account.</p>
                            <a href="<?php echo SITE_URL; ?>/login.php" class="btn btn-primary btn-lg w-100">
                                <i class="fas fa-sign-in-alt"></i> Login Now
                            </a>
                        </div>
                    <?php elseif ($error): ?>
                        <div class="alert alert-danger" role="alert">
                            <i class="fas fa-exclamation-circle"></i> <?php echo e($error); ?>
                        </div>
                        
                        <div class="text-center mt-4">
                            <p class="mb-3">The verification link may have expired or is invalid.</p>
                            
                            <div class="d-grid gap-2">
                                <a href="<?php echo SITE_URL; ?>/resend-verification.php" class="btn btn-outline-primary">
                                    <i class="fas fa-redo"></i> Resend Verification Email
                                </a>
                                <a href="<?php echo SITE_URL; ?>/login.php" class="btn btn-outline-secondary">
                                    <i class="fas fa-arrow-left"></i> Back to Login
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning" role="alert">
                            <i class="fas fa-info-circle"></i> No verification token provided.
                        </div>
                        
                        <div class="text-center mt-4">
                            <p class="mb-3">Please check your email for the verification link.</p>
                            <a href="<?php echo SITE_URL; ?>/login.php" class="btn btn-primary w-100">
                                <i class="fas fa-arrow-left"></i> Back to Login
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="text-center mt-3">
                <a href="<?php echo SITE_URL; ?>/index.php" class="text-decoration-none">
                    <i class="fas fa-home"></i> Back to Home
                </a>
            </div>
        </div>
    </div>
</div>

<?php include 'templates/footer.php'; ?>
