<?php
require_once '../config/config.php';

$db = getDB();

// Get all users
$stmt = $db->query('SELECT id, first_name, last_name, role_id FROM users ORDER BY id');
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Users in database:\n";
foreach ($users as $user) {
    echo "ID: {$user['id']} - {$user['first_name']} {$user['last_name']} (Role: {$user['role_id']})\n";
}

// Get institutions
$stmt = $db->query('SELECT id, name FROM institutions ORDER BY id');
$institutions = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "\nInstitutions in database:\n";
foreach ($institutions as $inst) {
    echo "ID: {$inst['id']} - {$inst['name']}\n";
}

// Get categories
$stmt = $db->query('SELECT id, name FROM categories ORDER BY id');
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "\nCategories in database:\n";
foreach ($categories as $cat) {
    echo "ID: {$cat['id']} - {$cat['name']}\n";
}

// Check existing studies and publications
$stmt = $db->query('SELECT COUNT(*) as count FROM studies');
$studiesCount = $stmt->fetch(PDO::FETCH_ASSOC)['count'];

$stmt = $db->query('SELECT COUNT(*) as count FROM publications');
$publicationsCount = $stmt->fetch(PDO::FETCH_ASSOC)['count'];

echo "\nExisting data:\n";
echo "Studies: {$studiesCount}\n";
echo "Publications: {$publicationsCount}\n";
?>