<?php
$uploadsDir = __DIR__ . '/../assets/uploads/profile_pictures/';
echo 'Directory path: ' . $uploadsDir . "\n";
echo 'Directory exists: ' . (is_dir($uploadsDir) ? 'Yes' : 'No') . "\n";

if (!is_dir($uploadsDir)) {
    echo 'Creating directory...' . "\n";
    if (mkdir($uploadsDir, 0755, true)) {
        echo 'Directory created successfully' . "\n";
    } else {
        echo 'Failed to create directory' . "\n";
    }
}

echo 'Directory writable: ' . (is_writable($uploadsDir) ? 'Yes' : 'No') . "\n";

// Check if there are any files
$files = glob($uploadsDir . '*.jpg');
echo 'JPG files found: ' . count($files) . "\n";
if (count($files) > 0) {
    echo 'Sample files: ' . implode(', ', array_slice($files, 0, 3)) . "\n";
} else {
    echo 'No JPG files found. Checking for any files...' . "\n";
    $allFiles = glob($uploadsDir . '*');
    echo 'Total files in directory: ' . count($allFiles) . "\n";
    if (count($allFiles) > 0) {
        echo 'Files: ' . implode(', ', $allFiles) . "\n";
    }
}
?>