<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();

    // Check total researchers
    $stmt = $db->query('SELECT COUNT(*) as count FROM users WHERE role_id = (SELECT id FROM roles WHERE name = "researcher" LIMIT 1)');
    $result = $stmt->fetch();
    echo 'Total researchers: ' . $result['count'] . "\n";

    // Check researchers with profile pictures
    $stmt = $db->query('SELECT COUNT(*) as count FROM researcher_profiles WHERE photo IS NOT NULL AND photo != ""');
    $result = $stmt->fetch();
    echo 'Researchers with profile pictures: ' . $result['count'] . "\n";

    // Check recent researchers (likely our new ones)
    $stmt = $db->query('SELECT u.first_name, u.last_name, rp.specialization, rp.photo FROM users u JOIN researcher_profiles rp ON u.id = rp.user_id WHERE u.role_id = (SELECT id FROM roles WHERE name = "researcher" LIMIT 1) ORDER BY u.id DESC LIMIT 5');
    $researchers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "\nMost recent researchers:\n";
    foreach ($researchers as $r) {
        $hasPhoto = !empty($r['photo']) ? 'Yes' : 'No';
        echo $r['first_name'] . ' ' . $r['last_name'] . ' - ' . $r['specialization'] . ' - Photo: ' . $hasPhoto . "\n";
    }

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage() . "\n";
}
?>