<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();
    $stmt = $db->query('SELECT u.first_name, u.last_name, rp.photo FROM users u JOIN researcher_profiles rp ON u.id = rp.user_id WHERE u.id = 125 LIMIT 1');
    $researcher = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($researcher) {
        $fullUrl = UPLOADS_URL . '/' . $researcher['photo'];
        echo 'Database path: ' . $researcher['photo'] . "\n";
        echo 'Full URL: ' . $fullUrl . "\n";

        // Convert URL back to file path
        $filePath = str_replace(UPLOADS_URL, ROOT_PATH . '/assets/uploads', $fullUrl);
        echo 'File path: ' . $filePath . "\n";
        echo 'File exists: ' . (file_exists($filePath) ? 'Yes' : 'No') . "\n";
    }
} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage() . "\n";
}
?>