<?php
require_once 'config/config.php';

// Start output
echo "<h2>Contact Requests API Test</h2>";

// Check if logged in
echo "<h3>Authentication Status:</h3>";
echo "<p>Session ID: " . session_id() . "</p>";
echo "<p>Is Logged In: " . (isLoggedIn() ? 'YES' : 'NO') . "</p>";
echo "<p>User ID: " . (getCurrentUserId() ?: 'NONE') . "</p>";
echo "<p>Session Data: <pre>" . print_r($_SESSION, true) . "</pre></p>";

if (!isLoggedIn()) {
    echo "<p style='color: red;'>You must be logged in to test the API</p>";
    exit;
}

$userId = getCurrentUserId();
$db = getDB();

// Test received requests query
echo "<h3>Testing Received Requests Query:</h3>";
try {
    $stmt = $db->prepare("
        SELECT cr.*, u.first_name, u.last_name, u.email, rp.photo,
               rp.specialization, rp.institution_id, i.name as institution_name
        FROM contact_requests cr
        JOIN users u ON cr.requester_id = u.id
        LEFT JOIN researcher_profiles rp ON u.id = rp.user_id
        LEFT JOIN institutions i ON rp.institution_id = i.id
        WHERE cr.target_id = ?
        ORDER BY cr.created_at DESC
    ");
    $stmt->execute([$userId]);
    $requests = $stmt->fetchAll();
    
    echo "<p style='color: green;'>Query executed successfully!</p>";
    echo "<p>Found " . count($requests) . " received requests</p>";
    echo "<pre>" . print_r($requests, true) . "</pre>";
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

// Test sent requests query
echo "<h3>Testing Sent Requests Query:</h3>";
try {
    $stmt = $db->prepare("
        SELECT cr.*, u.first_name, u.last_name, u.email, rp.photo,
               rp.specialization, rp.institution_id, i.name as institution_name
        FROM contact_requests cr
        JOIN users u ON cr.target_id = u.id
        LEFT JOIN researcher_profiles rp ON u.id = rp.user_id
        LEFT JOIN institutions i ON rp.institution_id = i.id
        WHERE cr.requester_id = ?
        ORDER BY cr.created_at DESC
    ");
    $stmt->execute([$userId]);
    $requests = $stmt->fetchAll();
    
    echo "<p style='color: green;'>Query executed successfully!</p>";
    echo "<p>Found " . count($requests) . " sent requests</p>";
    echo "<pre>" . print_r($requests, true) . "</pre>";
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

// Test actual API call
echo "<h3>Testing Actual API Call:</h3>";
echo "<p>Making request to: " . SITE_URL . "/api/contact-requests.php?type=received</p>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, SITE_URL . "/api/contact-requests.php?type=received");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());
curl_setopt($ch, CURLOPT_HEADER, true);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p>HTTP Status Code: " . $httpCode . "</p>";
echo "<h4>Response:</h4>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";
?>
