<?php
/**
 * Test Contact Requests Table
 */

require_once 'config/config.php';

echo "<h2>Testing Contact Requests Setup</h2>";

try {
    $db = getDB();
    
    // Check if contact_requests table exists
    echo "<h3>1. Checking if contact_requests table exists...</h3>";
    $stmt = $db->query("SHOW TABLES LIKE 'contact_requests'");
    $tableExists = $stmt->fetch();
    
    if ($tableExists) {
        echo "<p style='color: green;'>✓ contact_requests table exists</p>";
        
        // Show table structure
        echo "<h3>2. Table Structure:</h3>";
        $stmt = $db->query("DESCRIBE contact_requests");
        $columns = $stmt->fetchAll();
        echo "<pre>";
        print_r($columns);
        echo "</pre>";
        
        // Count records
        echo "<h3>3. Record Count:</h3>";
        $stmt = $db->query("SELECT COUNT(*) as count FROM contact_requests");
        $count = $stmt->fetch();
        echo "<p>Total records: " . $count['count'] . "</p>";
        
        // Check current user
        echo "<h3>4. Current User Info:</h3>";
        echo "<p>Logged in: " . (isLoggedIn() ? 'Yes' : 'No') . "</p>";
        echo "<p>User ID: " . (getCurrentUserId() ?: 'None') . "</p>";
        echo "<p>Session ID: " . session_id() . "</p>";
        echo "<p>Session data:</p>";
        echo "<pre>";
        print_r($_SESSION);
        echo "</pre>";
        
    } else {
        echo "<p style='color: red;'>✗ contact_requests table does NOT exist!</p>";
        echo "<p>You need to run the database migration to create this table.</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
