<?php
// test-db.php: Simple DB connection test for OBGYN Research Platform
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/config/database.php';

echo "<h2>Database Connection Test</h2>";
try {
    $db = getDB();
    $stmt = $db->query("SELECT NOW() as now");
    $row = $stmt->fetch();
    echo "<p style='color:green;'>Connection successful! Server time: " . htmlspecialchars($row['now']) . "</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>Connection failed: " . htmlspecialchars($e->getMessage()) . "</p>";
}
