</style>

<!-- Bootstrap 5 JS and Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php
/**
 * Admin Footer Template
 * Shared footer for all admin pages
 */

// Get system info
$phpVersion = phpversion();
$currentYear = date('Y');
$platformVersion = defined('PLATFORM_VERSION') ? PLATFORM_VERSION : '1.0.0';

// Get site name
$siteName = defined('SITE_NAME') ? SITE_NAME : 'OBGYN Research Platform';
?>

<!-- Admin Footer -->
<footer class="admin-footer bg-light border-top mt-auto py-3">
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-md-6 text-center text-md-start">
                <span class="text-muted">
                    &copy; <?php echo $currentYear; ?> <?php echo e($siteName); ?>. All rights reserved.
                </span>
                <span class="text-muted mx-2">|</span>
                <span class="text-muted">Version <?php echo $platformVersion; ?></span>
            </div>
            <div class="col-md-6 text-center text-md-end mt-2 mt-md-0">
                <a href="<?php echo SITE_URL; ?>/public/help.php" class="text-decoration-none text-muted me-3">
                    <i class="fas fa-question-circle"></i> Help
                </a>
                <a href="<?php echo SITE_URL; ?>/public/terms.php" class="text-decoration-none text-muted me-3">
                    <i class="fas fa-file-contract"></i> Terms
                </a>
                <a href="<?php echo SITE_URL; ?>/public/privacy.php" class="text-decoration-none text-muted">
                    <i class="fas fa-shield-alt"></i> Privacy
                </a>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-12 text-center">
                <small class="text-muted">
                    <i class="fas fa-server"></i> PHP <?php echo $phpVersion; ?>
                    <span class="mx-2">|</span>
                    <i class="fas fa-clock"></i> Server Time: <?php echo date('Y-m-d H:i:s'); ?>
                </small>
            </div>
        </div>
    </div>
</footer>

<style>
.admin-footer {
    position: relative;
    bottom: 0;
    width: 100%;
    margin-top: 3rem;
}

.admin-footer a:hover {
    color: var(--bs-primary) !important;
}

/* Ensure main content area pushes footer down */
body {
    display: flex;
    flex-direction: column;
    min-height: 100vh;
}

main {
    flex: 1;
}
</style>
