</main>
    
    <!-- Footer -->
    <footer class="bg-dark text-white mt-5 py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <?php 
                    $footerContactInfo = getContactInfo();
                    $footerCompanyName = !empty($footerContactInfo['company_name']) ? $footerContactInfo['company_name'] : getSiteName();
                    $footerTagline = !empty($footerContactInfo['tagline']) ? $footerContactInfo['tagline'] : '';
                    ?>
                    <h5><img src="<?php echo SITE_URL_DYNAMIC; ?>/assets/images/logo_white.png" alt="<?php echo e($footerCompanyName); ?>" height="32" class="me-2"> <?php echo e($footerCompanyName); ?></h5>
                    <?php if ($footerTagline): ?>
                        <p class="small text-white-50 fst-italic mb-2"><?php echo e($footerTagline); ?></p>
                    <?php endif; ?>
                    <p class="small">A comprehensive platform for OBGYN research collaboration, documentation, and global networking.</p>
                    <p class="small">Presented to Prof. Hesham Al Inany – Ganna Research Center</p>
                </div>
                <div class="col-md-2 mb-3">
                    <h6>Quick Links</h6>
                    <ul class="list-unstyled small">
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/index.php" class="text-white-50 text-decoration-none">Home</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/about.php" class="text-white-50 text-decoration-none">About</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/studies.php" class="text-white-50 text-decoration-none">Studies</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/researchers.php" class="text-white-50 text-decoration-none">Researchers</a></li>
                    </ul>
                </div>
                <div class="col-md-2 mb-3">
                    <h6>Resources</h6>
                    <ul class="list-unstyled small">
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/publications.php" class="text-white-50 text-decoration-none">Publications</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/help.php" class="text-white-50 text-decoration-none">Help Center</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/faq.php" class="text-white-50 text-decoration-none">FAQ</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/contact.php" class="text-white-50 text-decoration-none">Contact</a></li>
                    </ul>
                </div>
                <div class="col-md-2 mb-3">
                    <h6>Legal</h6>
                    <ul class="list-unstyled small">
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/privacy.php" class="text-white-50 text-decoration-none">Privacy Policy</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/terms.php" class="text-white-50 text-decoration-none">Terms of Service</a></li>
                        <li><a href="<?php echo SITE_URL_DYNAMIC; ?>/public/compliance.php" class="text-white-50 text-decoration-none">Compliance</a></li>
                    </ul>
                </div>
                <div class="col-md-2 mb-3">
                    <h6>Connect</h6>
                    <div class="d-flex gap-2 flex-wrap">
                        <?php 
                        $socialMedia = getSocialMediaLinks();
                        $socialIcons = [
                            'facebook' => 'fab fa-facebook',
                            'twitter' => 'fab fa-twitter',
                            'linkedin' => 'fab fa-linkedin',
                            'instagram' => 'fab fa-instagram',
                            'youtube' => 'fab fa-youtube',
                            'researchgate' => 'fab fa-researchgate',
                            'orcid' => 'fab fa-orcid'
                        ];
                        
                        foreach ($socialMedia as $platform => $url):
                            if (!empty($url) && isset($socialIcons[$platform])):
                        ?>
                            <a href="<?php echo e($url); ?>" target="_blank" class="text-white-50" title="<?php echo ucfirst($platform); ?>">
                                <i class="<?php echo $socialIcons[$platform]; ?> fa-lg"></i>
                            </a>
                        <?php 
                            endif;
                        endforeach;
                        
                        // Show default icons if no social media configured
                        if (empty($socialMedia)):
                        ?>
                            <a href="#" class="text-white-50"><i class="fab fa-facebook fa-lg"></i></a>
                            <a href="#" class="text-white-50"><i class="fab fa-twitter fa-lg"></i></a>
                            <a href="#" class="text-white-50"><i class="fab fa-linkedin fa-lg"></i></a>
                            <a href="#" class="text-white-50"><i class="fab fa-researchgate fa-lg"></i></a>
                        <?php endif; ?>
                    </div>
                    
                    <?php 
                    $contactInfo = getContactInfo();
                    if (!empty($contactInfo['email_primary']) || !empty($contactInfo['phone_primary'])):
                    ?>
                    <div class="mt-3 small">
                        <?php if (!empty($contactInfo['email_primary'])): ?>
                            <div class="mb-1">
                                <i class="fas fa-envelope me-1"></i>
                                <a href="mailto:<?php echo e($contactInfo['email_primary']); ?>" class="text-white-50 text-decoration-none">
                                    <?php echo e($contactInfo['email_primary']); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($contactInfo['phone_primary'])): ?>
                            <div>
                                <i class="fas fa-phone me-1"></i>
                                <a href="tel:<?php echo e($contactInfo['phone_primary']); ?>" class="text-white-50 text-decoration-none">
                                    <?php echo e($contactInfo['phone_primary']); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <hr class="bg-white">
            <div class="row">
                <div class="col-md-6 text-center text-md-start small">
                    <p class="mb-0">&copy; <?php echo date('Y'); ?> <?php echo e($footerTagline); ?>. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end small">
                    <p class="mb-0">Version <?php echo PLATFORM_VERSION; ?> | Built with <i class="fas fa-heart text-danger"></i> By <a href="https://www.alphacentaurii.com" target="_blank" class="text-white-50 text-decoration-none">AlphaCentaurii</a></p>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- Bootstrap 5 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    
    <!-- AOS (Animate On Scroll) JS -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <!-- LazyLoad JS -->
    <script src="https://cdn.jsdelivr.net/npm/vanilla-lazyload@17.8.3/dist/lazyload.min.js"></script>
    
    <!-- Custom JS -->
    <script src="<?php echo SITE_URL_DYNAMIC; ?>/assets/js/main.js"></script>
    
    <?php if (isset($additionalJS)): ?>
        <?php echo $additionalJS; ?>
    <?php endif; ?>
</body>
</html>
