<!-- Mobile Header -->
<header class="mobile-header d-lg-none" style="min-height: 70px; padding: 15px 0;">
    <div class="mobile-header-content">
        <!-- Left: Logo -->
        <div class="mobile-header-left">
            <?php
            $headerContactInfo = getContactInfo();
            $headerCompanyName = !empty($headerContactInfo['company_name']) ? $headerContactInfo['company_name'] : getSiteName();
            $logoUrl = getLogoUrl();
            ?>
            <a class="navbar-brand d-flex align-items-center gap-2 mb-0" href="<?php echo SITE_URL; ?>/index.php">
                <?php if ($logoUrl && file_exists(str_replace(SITE_URL, ROOT_PATH, $logoUrl))): ?>
                    <img src="<?php echo $logoUrl; ?>" alt="<?php echo e($headerCompanyName); ?>" height="40">
                <?php elseif (file_exists(ROOT_PATH . '/assets/images/logo.png')): ?>
                    <img src="<?php echo SITE_URL; ?>/assets/images/logo.png" alt="<?php echo e($headerCompanyName); ?>" height="40">
                <?php else: ?>
                    <img src="<?php echo SITE_URL; ?>/assets/images/logo.png" alt="<?php echo e($headerCompanyName); ?>" height="40">
                <?php endif; ?>
            </a>
        </div>

        <!-- Center: Website Title -->
        <div class="mobile-header-center">
            <h5 class="mb-0 fw-bold"><?php echo e($headerCompanyName); ?></h5>
        </div>

        <!-- Right: Icons -->
        <div class="mobile-header-right">
            <!-- Icons -->
            <div class="mobile-header-icons">
                <button class="btn btn-link text-dark p-2" onclick="showNewChatModal()">
                    <i class="fas fa-edit fa-lg"></i>
                </button>
                <button class="btn btn-link text-dark p-2" onclick="toggleMobileMenu()">
                    <i class="fas fa-bell fa-lg"></i>
                </button>
                <button class="btn btn-link text-dark p-2" data-bs-toggle="offcanvas" data-bs-target="#mobileMenu" aria-controls="mobileMenu">
                    <i class="fas fa-bars fa-lg"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Mobile Menu Offcanvas -->
    <div class="offcanvas offcanvas-end" tabindex="-1" id="mobileMenu" aria-labelledby="mobileMenuLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="mobileMenuLabel"><?php echo e($headerCompanyName); ?> Menu</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <nav class="mobile-nav">
                <!-- Quick Links -->
                <div class="mobile-nav-section">
                    <h6 class="mobile-nav-title">Quick Links</h6>
                    <ul class="mobile-nav-list">
                        <li><a href="<?php echo SITE_URL; ?>/index.php"><i class="fas fa-home"></i> Home</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/about.php"><i class="fas fa-info-circle"></i> About</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/studies.php"><i class="fas fa-flask"></i> Studies</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/researchers.php"><i class="fas fa-users"></i> Researchers</a></li>
                    </ul>
                </div>

                <!-- Resources -->
                <div class="mobile-nav-section">
                    <h6 class="mobile-nav-title">Resources</h6>
                    <ul class="mobile-nav-list">
                        <li><a href="<?php echo SITE_URL; ?>/public/publications.php"><i class="fas fa-book"></i> Publications</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/help.php"><i class="fas fa-question-circle"></i> Help Center</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/faq.php"><i class="fas fa-question"></i> FAQ</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/contact.php"><i class="fas fa-envelope"></i> Contact</a></li>
                    </ul>
                </div>

                <!-- Legal -->
                <div class="mobile-nav-section">
                    <h6 class="mobile-nav-title">Legal</h6>
                    <ul class="mobile-nav-list">
                        <li><a href="<?php echo SITE_URL; ?>/public/privacy.php"><i class="fas fa-shield-alt"></i> Privacy Policy</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/terms.php"><i class="fas fa-file-contract"></i> Terms of Service</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/public/compliance.php"><i class="fas fa-check-circle"></i> Compliance</a></li>
                    </ul>
                </div>

                <!-- Connect -->
                <div class="mobile-nav-section">
                    <h6 class="mobile-nav-title">Connect</h6>
                    <div class="mobile-social-links">
                        <?php
                        $socialMedia = getSocialMediaLinks();
                        if ($socialMedia):
                            foreach ($socialMedia as $platform => $url):
                                if (!empty($url)):
                                    $iconClass = '';
                                    switch ($platform) {
                                        case 'facebook': $iconClass = 'fab fa-facebook'; break;
                                        case 'twitter': $iconClass = 'fab fa-twitter'; break;
                                        case 'linkedin': $iconClass = 'fab fa-linkedin'; break;
                                        case 'instagram': $iconClass = 'fab fa-instagram'; break;
                                        case 'youtube': $iconClass = 'fab fa-youtube'; break;
                                        default: $iconClass = 'fas fa-external-link-alt';
                                    }
                        ?>
                                    <a href="<?php echo e($url); ?>" target="_blank" class="social-link">
                                        <i class="<?php echo $iconClass; ?>"></i>
                                    </a>
                        <?php
                                endif;
                            endforeach;
                        endif;
                        ?>
                    </div>
                </div>

                <!-- Auth Links -->
                <div class="mobile-nav-section">
                    <?php if (isLoggedIn()): ?>
                        <a href="<?php echo SITE_URL; ?>/logout.php" class="btn btn-outline-danger w-100">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    <?php else: ?>
                        <div class="d-grid gap-2">
                            <a href="<?php echo SITE_URL; ?>/login.php" class="btn btn-primary">Login</a>
                            <a href="<?php echo SITE_URL; ?>/register.php" class="btn btn-outline-primary">Register</a>
                        </div>
                    <?php endif; ?>
                </div>
            </nav>
        </div>
    </div>
</header>

<style>
/* Mobile Header Styles */
.mobile-header {
    position: sticky;
    top: 0;
    z-index: 1030;
    background: white;
    border-bottom: 1px solid #e9ecef;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.mobile-header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 12px 16px;
    min-height: 60px;
}

.mobile-header-left {
    flex: 0 0 auto;
}

.mobile-header-center {
    flex: 1;
    text-align: center;
    margin: 0 10px;
}

.mobile-header-right {
    flex: 0 0 auto;
    display: flex;
    align-items: center;
    gap: 8px;
}

.mobile-header-icons {
    display: flex;
    align-items: center;
    gap: 4px;
}

.mobile-search-container {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: white;
    padding: 12px 16px;
    border-bottom: 1px solid #e9ecef;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    z-index: 1020;
}

.mobile-search-container.show {
    display: block !important;
}

/* Mobile Navigation Styles */
.mobile-nav {
    padding: 0;
}

.mobile-nav-section {
    margin-bottom: 24px;
    padding-bottom: 16px;
    border-bottom: 1px solid #e9ecef;
}

.mobile-nav-section:last-child {
    border-bottom: none;
    margin-bottom: 0;
}

.mobile-nav-title {
    font-weight: 600;
    color: #495057;
    margin-bottom: 12px;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.mobile-nav-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.mobile-nav-list li {
    margin-bottom: 8px;
}

.mobile-nav-list a {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 8px 0;
    color: #6c757d;
    text-decoration: none;
    font-size: 0.9rem;
    transition: color 0.2s;
}

.mobile-nav-list a:hover {
    color: #0d6efd;
}

.mobile-nav-list a i {
    width: 18px;
    text-align: center;
}

.mobile-social-links {
    display: flex;
    gap: 16px;
    flex-wrap: wrap;
}

.social-link {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #f8f9fa;
    color: #6c757d;
    text-decoration: none;
    transition: all 0.2s;
}

.social-link:hover {
    background: #0d6efd;
    color: white;
    transform: translateY(-2px);
}

/* Responsive adjustments */
@media (max-width: 576px) {
    .mobile-header-content {
        padding: 10px 12px;
    }

    .mobile-header-center h6 {
        font-size: 0.9rem;
    }
}

/* Offcanvas backdrop override */
.offcanvas-backdrop {
    background: rgba(255, 255, 255, 0.7);
    backdrop-filter: blur(10px);
}
</style>

<script>
// Mobile header functionality
function toggleMobileMenu() {
    // Menu toggle is handled by Bootstrap offcanvas
}

function toggleMobileSearch() {
    const searchContainer = document.getElementById('mobile-search-container');
    const searchBtn = document.getElementById('search-btn');

    if (searchContainer.classList.contains('show')) {
        hideMobileSearch();
    } else {
        searchContainer.classList.add('show');
        searchBtn.style.display = 'none';
        const searchInput = document.getElementById('mobile-chat-search');
        if (searchInput) {
            searchInput.focus();
            // Connect to existing chat search functionality
            searchInput.addEventListener('input', function(e) {
                const chatSearchInput = document.getElementById('chat-search');
                if (chatSearchInput) {
                    chatSearchInput.value = e.target.value;
                    chatSearchInput.dispatchEvent(new Event('input'));
                }
            });
        }
    }
}

function hideMobileSearch() {
    const searchContainer = document.getElementById('mobile-search-container');
    const searchBtn = document.getElementById('search-btn');

    searchContainer.classList.remove('show');
    searchBtn.style.display = 'inline-block';
}

function showNewChatModal() {
    // This will be handled by the existing ChatManager
    if (typeof ChatManager !== 'undefined' && ChatManager.showNewChatModal) {
        ChatManager.showNewChatModal();
    }
}

// Close search when clicking outside
document.addEventListener('click', function(e) {
    const searchContainer = document.getElementById('mobile-search-container');
    const searchBtn = document.getElementById('search-btn');

    if (searchContainer && searchBtn &&
        !searchContainer.contains(e.target) &&
        !searchBtn.contains(e.target) &&
        searchContainer.classList.contains('show')) {
        hideMobileSearch();
    }
});
</script>