<?php
/**
 * Enhanced Admin Dashboard Sidebar
 * Phase 10: Improved structure with mobile support and logical grouping
 */

// Get current page for active state
$currentPage = basename($_SERVER['PHP_SELF']);

// Get counts for badges
$db = getDB();

// Pending users count
$stmt = $db->prepare("SELECT COUNT(*) FROM users WHERE status = 'pending'");
$stmt->execute();
$pendingUsers = $stmt->fetchColumn();

// Pending studies count
$stmt = $db->prepare("SELECT COUNT(*) FROM studies WHERE approval_status = 'pending'");
$stmt->execute();
$pendingStudies = $stmt->fetchColumn();

// Pending publications count
$stmt = $db->prepare("SELECT COUNT(*) FROM publications WHERE approval_status = 'pending'");
$stmt->execute();
$pendingPublications = $stmt->fetchColumn();

// Unread notifications count (if needed)
$unreadNotifications = 0;
?>

<!-- Mobile Menu Toggle Button -->
<button class="btn btn-primary d-md-none mobile-menu-toggle" type="button" id="sidebarToggle">
    <i class="fas fa-bars"></i> Menu
</button>

<!-- Sidebar Overlay for Mobile -->
<div class="sidebar-overlay d-md-none" id="sidebarOverlay"></div>

<!-- Admin Sidebar -->
<nav class="col-md-3 col-lg-2 d-md-block bg-dark sidebar" id="adminSidebar">
    <div class="position-sticky pt-3">
        <!-- Close button for mobile -->
        <button class="btn btn-sm btn-outline-light d-md-none mb-3 ms-3" id="sidebarClose">
            <i class="fas fa-times"></i> Close
        </button>
        
        <!-- Dashboard -->
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
            </li>
        </ul>
        
        <hr class="sidebar-divider">
        
        <!-- User Management Section -->
        <h6 class="sidebar-heading">
            <i class="fas fa-users-cog"></i> USER MANAGEMENT
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'users.php' ? 'active' : ''; ?>" href="users.php">
                    <i class="fas fa-users"></i> Users
                    <?php if ($pendingUsers > 0): ?>
                        <span class="badge bg-warning"><?php echo $pendingUsers; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-muted disabled" href="#" title="Coming in Phase 10.2">
                    <i class="fas fa-user-shield"></i> Roles & Permissions
                    <small class="badge bg-secondary">Soon</small>
                </a>
            </li>
        </ul>
        
        <hr class="sidebar-divider">
        
        <!-- Research Management Section -->
        <h6 class="sidebar-heading">
            <i class="fas fa-flask"></i> RESEARCH MANAGEMENT
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'studies.php' ? 'active' : ''; ?>" href="studies.php">
                    <i class="fas fa-microscope"></i> Studies
                    <?php if ($pendingStudies > 0): ?>
                        <span class="badge bg-warning"><?php echo $pendingStudies; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'publications.php' ? 'active' : ''; ?>" href="publications.php">
                    <i class="fas fa-book"></i> Publications
                    <?php if ($pendingPublications > 0): ?>
                        <span class="badge bg-warning"><?php echo $pendingPublications; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'categories.php' ? 'active' : ''; ?>" href="categories.php">
                    <i class="fas fa-tags"></i> Categories
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'institutions.php' ? 'active' : ''; ?>" href="institutions.php">
                    <i class="fas fa-university"></i> Institutions
                </a>
            </li>
        </ul>
        
        <hr class="sidebar-divider">
        
        <!-- Content Management Section -->
        <h6 class="sidebar-heading">
            <i class="fas fa-edit"></i> CONTENT MANAGEMENT
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-posts.php' || $currentPage === 'cms-posts-edit.php' ? 'active' : ''; ?>" href="cms-posts.php">
                    <i class="fas fa-newspaper"></i> Blog Posts
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-pages.php' || $currentPage === 'cms-pages-edit.php' ? 'active' : ''; ?>" href="cms-pages.php">
                    <i class="fas fa-file-alt"></i> Pages
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-menus.php' || $currentPage === 'cms-menu-items.php' ? 'active' : ''; ?>" href="cms-menus.php">
                    <i class="fas fa-bars"></i> Menus
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-contact.php' ? 'active' : ''; ?>" href="cms-contact.php">
                    <i class="fas fa-address-card"></i> Contact Info
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-muted disabled" href="#" title="Coming in Phase 10.2">
                    <i class="fas fa-images"></i> Media Library
                    <small class="badge bg-secondary">Soon</small>
                </a>
            </li>
        </ul>
        
        <hr class="sidebar-divider">
        
        <!-- System Section -->
        <h6 class="sidebar-heading">
            <i class="fas fa-cogs"></i> SYSTEM
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'settings.php' ? 'active' : ''; ?>" href="settings.php">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'analytics.php' ? 'active' : ''; ?>" href="analytics.php">
                    <i class="fas fa-chart-line"></i> Analytics
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'audit-logs.php' ? 'active' : ''; ?>" href="audit-logs.php">
                    <i class="fas fa-history"></i> Audit Logs
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'moderation.php' ? 'active' : ''; ?>" href="moderation.php">
                    <i class="fas fa-shield-alt"></i> Moderation
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-muted disabled" href="#" title="Coming in Phase 10.2">
                    <i class="fas fa-database"></i> Backups
                    <small class="badge bg-secondary">Soon</small>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-muted disabled" href="#" title="Coming in Phase 10.2">
                    <i class="fas fa-heartbeat"></i> System Health
                    <small class="badge bg-secondary">Soon</small>
                </a>
            </li>
        </ul>
        
        <hr class="sidebar-divider">
        
        <!-- Quick Actions -->
        <ul class="nav flex-column mb-3">
            <li class="nav-item">
                <a class="nav-link" href="<?php echo SITE_URL; ?>/index.php" target="_blank">
                    <i class="fas fa-external-link-alt"></i> View Site
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo SITE_URL; ?>/logout.php">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </li>
        </ul>
    </div>
</nav>

<style>
/* Sidebar Base Styles */
.sidebar {
    position: fixed;
    top: 56px;
    bottom: 0;
    left: 0;
    z-index: 100;
    padding: 0;
    box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
    overflow-y: auto;
    overflow-x: hidden;
    transition: transform 0.3s ease-in-out;
}

.sidebar::-webkit-scrollbar {
    width: 6px;
}

.sidebar::-webkit-scrollbar-track {
    background: #1a1a1a;
}

.sidebar::-webkit-scrollbar-thumb {
    background: #555;
    border-radius: 3px;
}

.sidebar::-webkit-scrollbar-thumb:hover {
    background: #777;
}

/* Sidebar Divider */
.sidebar-divider {
    border-color: rgba(255, 255, 255, 0.1);
    margin: 0.5rem 0;
}

/* Sidebar Heading */
.sidebar-heading {
    font-size: 0.7rem;
    text-transform: uppercase;
    letter-spacing: 0.05rem;
    font-weight: 600;
    color: rgba(255, 255, 255, 0.5);
    padding: 0.75rem 1rem 0.5rem;
    margin: 0;
}

.sidebar-heading i {
    margin-right: 0.5rem;
    font-size: 0.8rem;
}

/* Nav Links */
.sidebar .nav-link {
    font-weight: 500;
    color: rgba(255, 255, 255, 0.8);
    padding: 0.75rem 1rem;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.sidebar .nav-link:hover:not(.disabled) {
    background-color: rgba(255, 255, 255, 0.1);
    color: #fff;
    padding-left: 1.25rem;
}

.sidebar .nav-link.active {
    color: #fff;
    background-color: rgba(13, 110, 253, 0.3);
    border-left: 3px solid #007bff;
}

.sidebar .nav-link i {
    margin-right: 0.75rem;
    width: 20px;
    text-align: center;
}

.sidebar .nav-link.disabled {
    cursor: not-allowed;
    opacity: 0.5;
}

.sidebar .nav-link .badge {
    font-size: 0.7rem;
    padding: 0.25rem 0.5rem;
}

/* Mobile Menu Toggle */
.mobile-menu-toggle {
    position: fixed;
    top: 70px;
    left: 15px;
    z-index: 1040;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
}

/* Sidebar Overlay */
.sidebar-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 99;
    display: none;
}

.sidebar-overlay.show {
    display: block;
}

/* Mobile Sidebar Styles */
@media (max-width: 767.98px) {
    .sidebar {
        transform: translateX(-100%);
        width: 280px;
        top: 0;
        z-index: 1050;
    }
    
    .sidebar.show {
        transform: translateX(0);
    }
    
    main {
        margin-left: 0 !important;
    }
}

/* Desktop Styles */
@media (min-width: 768px) {
    .mobile-menu-toggle,
    .sidebar-overlay,
    #sidebarClose {
        display: none !important;
    }
    
    main {
        margin-top: 56px;
    }
}

/* Main Content Adjustment */
main {
    margin-top: 56px;
}

@media (min-width: 768px) {
    main {
        margin-left: 16.666667%; /* col-md-3 equivalent */
    }
}

@media (min-width: 992px) {
    main {
        margin-left: 16.666667%; /* col-lg-2 equivalent */
    }
}
</style>

<script>
// Mobile Menu Toggle Script
document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.getElementById('adminSidebar');
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebarClose = document.getElementById('sidebarClose');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.add('show');
            sidebarOverlay.classList.add('show');
            document.body.style.overflow = 'hidden';
        });
    }
    
    function closeSidebar() {
        sidebar.classList.remove('show');
        sidebarOverlay.classList.remove('show');
        document.body.style.overflow = '';
    }
    
    if (sidebarClose) {
        sidebarClose.addEventListener('click', closeSidebar);
    }
    
    if (sidebarOverlay) {
        sidebarOverlay.addEventListener('click', closeSidebar);
    }
    
    // Close sidebar when clicking a link on mobile
    const sidebarLinks = sidebar.querySelectorAll('.nav-link:not(.disabled)');
    sidebarLinks.forEach(link => {
        link.addEventListener('click', function() {
            if (window.innerWidth < 768) {
                closeSidebar();
            }
        });
    });
});
</script>
