<?php
// Determine the correct path to config
$configPath = '';
if (file_exists(__DIR__ . '/../config/config.php')) {
    $configPath = __DIR__ . '/../config/config.php';
} elseif (file_exists(dirname(dirname(__FILE__)) . '/config/config.php')) {
    $configPath = dirname(dirname(__FILE__)) . '/config/config.php';
}

if ($configPath && !defined('ROOT_PATH')) {
    require_once $configPath;
}

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$pageTitle = $pageTitle ?? 'Admin Panel';
$flashMessage = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://code.jquery.com; font-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data:;">
    <title><?php echo e($pageTitle); ?> - Admin Panel</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo SITE_URL_DYNAMIC; ?>/assets/css/style.css">
    
    <?php if (isset($additionalCSS)): ?>
        <?php echo $additionalCSS; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Admin Top Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo SITE_URL_DYNAMIC; ?>/admin/dashboard.php">
                <i class="fas fa-shield-alt"></i>
                <?php echo e(getSiteName()); ?> - Admin
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#adminNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="adminNav">
                <ul class="navbar-nav ms-auto">
                    <!-- Notifications -->
                    <li class="nav-item dropdown">
                        <a class="nav-link position-relative" href="#" id="notificationsDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-bell"></i>
                            <?php 
                            $db = getDB();
                            $stmt = $db->prepare("SELECT COUNT(*) FROM users WHERE status = 'pending'");
                            $stmt->execute();
                            $pendingCount = $stmt->fetchColumn();
                            
                            $stmt = $db->prepare("SELECT COUNT(*) FROM studies WHERE approval_status = 'pending'");
                            $stmt->execute();
                            $pendingCount += $stmt->fetchColumn();
                            
                            if ($pendingCount > 0): 
                            ?>
                                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                    <?php echo $pendingCount > 9 ? '9+' : $pendingCount; ?>
                                </span>
                            <?php endif; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><h6 class="dropdown-header">Pending Actions</h6></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/admin/users.php?filter=pending">
                                <i class="fas fa-users"></i> Pending Users
                            </a></li>
                            <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/admin/studies.php?filter=pending">
                                <i class="fas fa-flask"></i> Pending Studies
                            </a></li>
                        </ul>
                    </li>
                    
                    <!-- User Menu -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle"></i> <?php echo e($_SESSION['user_name'] ?? 'Admin'); ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/index.php">
                                <i class="fas fa-home"></i> View Site
                            </a></li>
                            <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/profile.php">
                                <i class="fas fa-user"></i> My Profile
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/logout.php">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- Flash Messages -->
    <?php if ($flashMessage): ?>
        <div class="container-fluid" style="margin-top: 56px;">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-<?php echo $flashMessage['type'] === 'error' ? 'danger' : $flashMessage['type']; ?> alert-dismissible fade show mt-3" role="alert">
                        <?php echo e($flashMessage['message']); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
