<!-- Footer Navigation Bar -->
<style>
/* Footer Navigation */
.footer-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    z-index: 1000;
    width: 100%;
    margin: 0;
    padding: 12px 0;
    min-height: 80px;
    background-color: #fff;
    box-shadow: 0 -2px 4px rgba(0,0,0,0.1);
}

.nav-container {
    display: flex;
    width: calc(100vw - 10px);
    overflow-x: auto;
    scrollbar-width: none;
    -ms-overflow-style: none;
    padding: 8px;
    gap: 16px;
    justify-content: flex-start;
    transition: transform 0.8s ease-in-out;
    scroll-snap-type: x mandatory;
    scroll-behavior: smooth;
    margin: 0 auto;
}

.nav-container.scroll-hint {
    transform: translateX(-10%);
}

.nav-container::-webkit-scrollbar {
    display: none;
}

.nav-item {
    flex: 0 0 auto;
    min-width: 100px;
    padding: 12px 6px;
    text-align: center;
    text-decoration: none;
    color: #6c757d;
    transition: color 0.2s;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 6px;
    scroll-snap-align: center;
}

.nav-item:hover,
.nav-item.active {
    color: #0d6efd;
}

.nav-item i {
    font-size: 1.4rem;
}

.nav-item span {
    font-size: 0.8rem;
    font-weight: 500;
}

/* Hide footer on desktop */
@media (min-width: 992px) {
    .footer-nav {
        display: none;
    }
}

/* Animation for scroll hint */
@keyframes scrollHint {
    0%, 100% {
        transform: translateX(0);
    }
    50% {
        transform: translateX(-10px);
    }
}

.scroll-hint {
    animation: scrollHint 1.5s ease-in-out infinite;
}
</style>

<script>
// Footer Navigation JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Footer navigation click handling
    const navItems = document.querySelectorAll('.nav-item');
    navItems.forEach(item => {
        item.addEventListener('click', (e) => {
            e.preventDefault();
            const href = item.getAttribute('href');
            if (href) {
                window.location.href = href;
            }
        });
    });

    // Initialize scroll behavior
    initScrollBehavior();
    
    // Start scroll hint animation
    startScrollHintAnimation();
});

function initScrollBehavior() {
    const navContainer = document.querySelector('.nav-container');
    if (!navContainer) return;
    
    // Center the active item on load
    const activeItem = document.querySelector('.nav-item.active');
    if (activeItem) {
        setTimeout(() => {
            centerActiveItem();
        }, 100);
    }
    
    // Add smooth scrolling behavior
    let isScrolling = false;
    navContainer.addEventListener('scroll', () => {
        if (!isScrolling) {
            isScrolling = true;
            setTimeout(() => {
                snapToNearestItem();
                isScrolling = false;
            }, 100);
        }
    });
    
    // Add touch/drag support
    let startX = 0;
    let scrollLeft = 0;
    
    navContainer.addEventListener('touchstart', (e) => {
        startX = e.touches[0].pageX - navContainer.offsetLeft;
        scrollLeft = navContainer.scrollLeft;
    });
    
    navContainer.addEventListener('touchmove', (e) => {
        if (!startX) return;
        const x = e.touches[0].pageX - navContainer.offsetLeft;
        const walk = (x - startX) * 2; // Scroll speed multiplier
        navContainer.scrollLeft = scrollLeft - walk;
    });
}

function centerActiveItem() {
    const navContainer = document.querySelector('.nav-container');
    const activeItem = document.querySelector('.nav-item.active');
    
    if (!navContainer || !activeItem) return;
    
    const containerWidth = navContainer.clientWidth;
    const itemWidth = activeItem.offsetWidth;
    const itemOffset = activeItem.offsetLeft;
    
    // Calculate scroll position to center the active item
    const scrollPosition = itemOffset - (containerWidth / 2) + (itemWidth / 2);
    
    navContainer.scrollTo({
        left: scrollPosition,
        behavior: 'smooth'
    });
}

function snapToNearestItem() {
    const navContainer = document.querySelector('.nav-container');
    if (!navContainer) return;
    
    const items = document.querySelectorAll('.nav-item');
    if (items.length === 0) return;
    
    const containerWidth = navContainer.clientWidth;
    const scrollPosition = navContainer.scrollLeft;
    
    // Find the item closest to the center
    let closestItem = items[0];
    let minDistance = Infinity;
    
    items.forEach(item => {
        const itemCenter = item.offsetLeft + (item.offsetWidth / 2);
        const containerCenter = scrollPosition + (containerWidth / 2);
        const distance = Math.abs(itemCenter - containerCenter);
        
        if (distance < minDistance) {
            minDistance = distance;
            closestItem = item;
        }
    });
    
    // Snap to the closest item
    const itemWidth = closestItem.offsetWidth;
    const itemOffset = closestItem.offsetLeft;
    const targetScroll = itemOffset - (containerWidth / 2) + (itemWidth / 2);
    
    navContainer.scrollTo({
        left: targetScroll,
        behavior: 'smooth'
    });
}

function startScrollHintAnimation() {
    // Increasing intervals: 10s, 15s, 30s, 60s, 120s, then repeat
    const intervals = [10000, 15000, 30000, 60000, 120000];
    let currentIntervalIndex = 0;

    const triggerAnimation = () => {
        const navContainer = document.querySelector('.nav-container');
        if (navContainer) {
            // Add scroll hint animation class
            navContainer.classList.add('scroll-hint');
            
            // Remove the class after animation completes
            setTimeout(() => {
                navContainer.classList.remove('scroll-hint');
            }, 1500);
            
            // Get the center position of the visible area
            const containerWidth = navContainer.clientWidth;
            const currentScroll = navContainer.scrollLeft;
            
            // Check if we can scroll further
            const maxScroll = navContainer.scrollWidth - containerWidth;
            if (currentScroll < maxScroll) {
                // Scroll to show next set of items
                const scrollTarget = Math.min(currentScroll + (containerWidth * 0.8), maxScroll);
                
                navContainer.scrollTo({
                    left: scrollTarget,
                    behavior: 'smooth'
                });

                setTimeout(() => {
                    // Scroll back to original position
                    navContainer.scrollTo({
                        left: currentScroll,
                        behavior: 'smooth'
                    });
                }, 1000);
            }
        }

        // Schedule next animation with current interval, then increment
        const nextInterval = intervals[currentIntervalIndex];
        currentIntervalIndex = (currentIntervalIndex + 1) % intervals.length;
        setTimeout(triggerAnimation, nextInterval);
    };

    // Start the first animation after 10 seconds
    setTimeout(triggerAnimation, intervals[0]);
}
</script>

<nav class="footer-nav">
    <div class="nav-container">
        <a href="<?php echo SITE_URL; ?>/researcher/dashboard.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>Dashboard</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/researcher/profile.php" class="nav-item">
            <i class="fas fa-user"></i>
            <span>Profile</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/researcher/messages-enhanced.php" class="nav-item active">
            <i class="fas fa-envelope"></i>
            <span>Chats</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/researcher/studies.php" class="nav-item">
            <i class="fas fa-flask"></i>
            <span>Studies</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/researcher/connections.php" class="nav-item">
            <i class="fas fa-user-friends"></i>
            <span>Connections</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/researcher/collaborations.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>Collaborations</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/researcher/notifications-enhanced.php" class="nav-item">
            <i class="fas fa-bell"></i>
            <span>Notifications</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/researcher/settings.php" class="nav-item">
            <i class="fas fa-cog"></i>
            <span>Settings</span>
        </a>
    </div>
</nav>